/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.DelayedExecutor;
import com.linkedin.parseq.Engine;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.internal.IdGenerator;
import com.linkedin.parseq.internal.PlanCompletionListener;
import com.linkedin.parseq.internal.PlanDeactivationListener;
import com.linkedin.parseq.internal.PrioritizableRunnable;
import com.linkedin.parseq.internal.SerialExecutionException;
import com.linkedin.parseq.internal.SerialExecutor;
import com.linkedin.parseq.internal.TaskLogger;
import com.linkedin.parseq.internal.UncaughtExceptionHandler;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)PlanContext.class.getName());
    private final Long _id;
    private final Engine _engine;
    private final String _planClass;
    private final Task<?> _root;
    private final SerialExecutor _taskExecutor;
    private final DelayedExecutor _timerScheduler;
    private final TaskLogger _taskLogger;
    private final TraceBuilder _relationshipsBuilder;
    private final PlanCompletionListener _planCompletionListener;
    private final AtomicInteger _pending;

    public PlanContext(Engine engine, Executor taskExecutor, DelayedExecutor timerExecutor, ILoggerFactory loggerFactory, Logger allLogger, Logger rootLogger, String planClass, Task<?> root, int maxRelationshipsPerTrace, PlanDeactivationListener planDeactivationListener, PlanCompletionListener planCompletionListener, SerialExecutor.TaskQueue<PrioritizableRunnable> taskQueue) {
        this._id = IdGenerator.getNextId();
        this._root = root;
        this._relationshipsBuilder = new TraceBuilder(maxRelationshipsPerTrace, planClass, this._id);
        this._engine = engine;
        this._taskExecutor = new SerialExecutor(taskExecutor, new CancellingPlanExceptionHandler(root), () -> {
            try {
                planDeactivationListener.onPlanDeactivated(this);
            }
            catch (Throwable t) {
                LOG.error("Failed to notify deactivation listener " + planDeactivationListener, t);
            }
        }, taskQueue);
        this._timerScheduler = timerExecutor;
        Logger planLogger = loggerFactory.getLogger(Engine.LOGGER_BASE + ":planClass=" + planClass);
        this._taskLogger = new TaskLogger(this._id, root.getId(), allLogger, rootLogger, planLogger);
        this._planClass = planClass;
        this._planCompletionListener = planCompletionListener;
        this._pending = new AtomicInteger(1);
        this._root.addListener(p -> this.done());
    }

    private PlanContext(Task<?> root, Long id, Engine engine, SerialExecutor serialExecutor, DelayedExecutor scheduler, String planClass, TaskLogger taskLogger, TraceBuilder relationshipsBuilder, PlanCompletionListener planCompletionListener) {
        this._root = root;
        this._id = id;
        this._engine = engine;
        this._taskExecutor = serialExecutor;
        this._timerScheduler = scheduler;
        this._planClass = planClass;
        this._taskLogger = taskLogger;
        this._relationshipsBuilder = relationshipsBuilder;
        this._planCompletionListener = planCompletionListener;
        this._pending = new AtomicInteger(1);
        this._root.addListener(p -> this.done());
    }

    public Long getId() {
        return this._id;
    }

    public void execute(PrioritizableRunnable runnable) {
        this._taskExecutor.execute(runnable);
    }

    public Cancellable schedule(long time, TimeUnit unit, Runnable runnable) {
        return this._timerScheduler.schedule(time, unit, runnable);
    }

    public Object getEngineProperty(String key) {
        return this._engine.getProperty(key);
    }

    public TaskLogger getTaskLogger() {
        return this._taskLogger;
    }

    public TraceBuilder getRelationshipsBuilder() {
        return this._relationshipsBuilder;
    }

    public String getPlanClass() {
        return this._planClass;
    }

    public Task<?> getRootTask() {
        return this._root;
    }

    public PlanContext fork(Task<?> root) {
        int pending;
        while ((pending = this._pending.get()) > 0) {
            if (!this._pending.compareAndSet(pending, pending + 1)) continue;
            return new PlanContext(root, this._id, this._engine, this._taskExecutor, this._timerScheduler, this._planClass, this._taskLogger, this._relationshipsBuilder, p -> this.done());
        }
        return null;
    }

    private void done() {
        if (this._pending.decrementAndGet() == 0) {
            this._planCompletionListener.onPlanCompleted(this);
        }
    }

    private static class CancellingPlanExceptionHandler
    implements UncaughtExceptionHandler {
        private final Task<?> _task;

        private CancellingPlanExceptionHandler(Task<?> task) {
            this._task = task;
        }

        @Override
        public void uncaughtException(Throwable error) {
            String msg = "Serial executor loop failed for plan: " + this._task.getName();
            SerialExecutionException ex = new SerialExecutionException(msg, error);
            boolean wasCancelled = this._task.cancel(ex);
            LOG.error(msg + ". The plan was " + (wasCancelled ? "" : "not ") + "cancelled.", (Throwable)ex);
        }
    }
}

