/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.internal.Prioritizable;
import com.linkedin.parseq.internal.SerialExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class FIFOPriorityQueue<T extends Prioritizable>
implements SerialExecutor.TaskQueue<T> {
    private final BlockingQueue<Entry<T>> _queue = new PriorityBlockingQueue<Entry<T>>();
    private final AtomicLong _sequenceNumber = new AtomicLong();

    @Override
    public void add(T value) {
        this._queue.add(new Entry(this._sequenceNumber.getAndIncrement(), (Prioritizable)value, null));
    }

    @Override
    public T poll() {
        Entry entry = (Entry)this._queue.poll();
        return (T)(entry == null ? null : entry._value);
    }

    private static class Entry<T extends Prioritizable>
    implements Comparable<Entry<T>> {
        private final long _sequenceNumber;
        private final T _value;

        private Entry(long sequenceNumber, T value) {
            this._sequenceNumber = sequenceNumber;
            this._value = value;
        }

        @Override
        public int compareTo(Entry<T> o) {
            int comp = this.compare(o._value.getPriority(), this._value.getPriority());
            return comp == 0 ? this.compare(this._sequenceNumber, o._sequenceNumber) : comp;
        }

        private int compare(long lhs, long rhs) {
            if (lhs < rhs) {
                return -1;
            }
            if (lhs > rhs) {
                return 1;
            }
            return 0;
        }

        /* synthetic */ Entry(long x0, Prioritizable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

