/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.DelayedExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class IndirectDelayedExecutor
implements DelayedExecutor {
    private final DelayedExecutor _executor;

    public IndirectDelayedExecutor(DelayedExecutor executor) {
        this._executor = executor;
    }

    @Override
    public Cancellable schedule(long delay, TimeUnit unit, Runnable command) {
        IndirectRunnable indirectRunnable = new IndirectRunnable(command);
        Cancellable cancellable = this._executor.schedule(delay, unit, indirectRunnable);
        return new IndirectCancellable(cancellable, indirectRunnable);
    }

    private static class IndirectCancellable
    implements Cancellable {
        private final Cancellable _cancellable;
        private final IndirectRunnable _runnable;

        private IndirectCancellable(Cancellable cancellable, IndirectRunnable runnable) {
            this._cancellable = cancellable;
            this._runnable = runnable;
        }

        @Override
        public boolean cancel(Exception reason) {
            return this._runnable.cancel() && this._cancellable.cancel(reason);
        }
    }

    private static class IndirectRunnable
    implements Runnable {
        private AtomicReference<Runnable> _commandRef;

        public IndirectRunnable(Runnable command) {
            this._commandRef = new AtomicReference<Runnable>(command);
        }

        @Override
        public void run() {
            Runnable runnable = this._commandRef.get();
            if (runnable != null && this._commandRef.compareAndSet(runnable, null)) {
                runnable.run();
            }
        }

        public boolean cancel() {
            Runnable runnable = this._commandRef.get();
            return runnable != null && this._commandRef.compareAndSet(runnable, null);
        }
    }
}

