/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.tunnel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.gobblin.tunnel.AcceptHandler;
import org.apache.gobblin.tunnel.Config;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tunnel {
    public static final int NON_EXISTENT_PORT = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Tunnel.class);
    private ServerSocketChannel server;
    private Thread thread;
    private final Config config;

    private Tunnel(String remoteHost, int remotePort, String proxyHost, int proxyPort) {
        this.config = new Config(remoteHost, remotePort, proxyHost, proxyPort);
    }

    private Tunnel open() throws IOException {
        try {
            this.server = ServerSocketChannel.open().bind(null);
            this.server.configureBlocking(false);
            Selector selector = Selector.open();
            this.startTunnelThread(selector);
            return this;
        }
        catch (IOException ioe) {
            LOG.error("Failed to open the tunnel", (Throwable)ioe);
            throw ioe;
        }
    }

    public int getPort() throws IOException {
        SocketAddress localAddress = null;
        try {
            if (this.server != null && this.server.isOpen()) {
                localAddress = this.server.getLocalAddress();
            }
            if (localAddress instanceof InetSocketAddress) {
                return ((InetSocketAddress)localAddress).getPort();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get tunnel port", (Throwable)e);
            throw e;
        }
        return -1;
    }

    private void startTunnelThread(Selector selector) {
        this.thread = new Thread((Runnable)new Dispatcher(selector), "Tunnel Listener");
        this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Uncaught exception in thread " + t.getName(), e);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean isTunnelThreadAlive() {
        return this.thread != null && this.thread.isAlive();
    }

    public void close() {
        try {
            this.server.close();
            LOG.info("Closed tunnel.");
        }
        catch (IOException ioe) {
            LOG.warn("Exception during shutdown of tunnel", (Throwable)ioe);
        }
        finally {
            try {
                this.thread.interrupt();
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Tunnel build(String remoteHost, int remotePort, String proxyHost, int proxyPort) throws IOException {
        return new Tunnel(remoteHost, remotePort, proxyHost, proxyPort).open();
    }

    private class Dispatcher
    implements Runnable {
        private final Selector selector;

        public Dispatcher(Selector selector) {
            this.selector = selector;
        }

        @Override
        public void run() {
            try {
                Tunnel.this.server.register(this.selector, 16, ExecutorsUtils.loggingDecorator((Callable)new AcceptHandler(Tunnel.this.server, this.selector, Tunnel.this.config)));
                while (!Thread.interrupted()) {
                    this.selector.select();
                    Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                    for (SelectionKey selectionKey : selectionKeys) {
                        this.dispatch(selectionKey);
                    }
                    selectionKeys.clear();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unhandled IOException. Tunnel will close", (Throwable)ioe);
            }
            LOG.info("Closing tunnel");
        }

        private void dispatch(SelectionKey selectionKey) {
            Callable attachment = (Callable)selectionKey.attachment();
            try {
                attachment.call();
            }
            catch (Exception e) {
                LOG.error("exception handling event on {}", (Object)selectionKey.channel(), (Object)e);
            }
        }
    }
}

