/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.tunnel;

import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import org.apache.gobblin.tunnel.Config;
import org.apache.gobblin.tunnel.HandlerState;
import org.apache.gobblin.tunnel.ProxySetupHandler;
import org.apache.gobblin.tunnel.Tunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcceptHandler
implements Callable<HandlerState> {
    private static final Logger LOG = LoggerFactory.getLogger(Tunnel.class);
    private final ServerSocketChannel server;
    private final Selector selector;
    private final Config config;

    AcceptHandler(ServerSocketChannel server, Selector selector, Config config) {
        this.config = config;
        this.server = server;
        this.selector = selector;
    }

    @Override
    public HandlerState call() throws Exception {
        SocketChannel client = this.server.accept();
        LOG.info("Accepted connection from {}", (Object)client.getRemoteAddress());
        try {
            new ProxySetupHandler(client, this.selector, this.config);
        }
        catch (IOException ioe) {
            client.close();
        }
        return HandlerState.ACCEPTING;
    }
}

