/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.HttpServer;
import com.linkedin.r2.transport.http.server.RAPServerCodec;
import com.linkedin.r2.util.NamedThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpNettyServer
implements HttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpNettyServer.class);
    private final int _port;
    private final int _threadPoolSize;
    private final HttpDispatcher _dispatcher;
    private final boolean _restOverStream;
    private NioEventLoopGroup _bossGroup;
    private NioEventLoopGroup _workerGroup;
    private EventExecutorGroup _eventExecutors;

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher) {
        this(port, threadPoolSize, dispatcher, false);
    }

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher, boolean restOverStream) {
        this._port = port;
        this._threadPoolSize = threadPoolSize;
        this._dispatcher = dispatcher;
        this._restOverStream = restOverStream;
    }

    public void start() {
        this._eventExecutors = new DefaultEventExecutorGroup(this._threadPoolSize);
        this._bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("R2 Nio Boss"));
        this._workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Worker"));
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this._bossGroup, (EventLoopGroup)this._workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) throws Exception {
                ch.pipeline().addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
                ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                ch.pipeline().addLast("rapi", (ChannelHandler)new RAPServerCodec());
                ch.pipeline().addLast(HttpNettyServer.this._eventExecutors, "handler", (ChannelHandler)(HttpNettyServer.this._restOverStream ? new StreamHandler() : new RestHandler()));
            }
        });
        bootstrap.bind((SocketAddress)new InetSocketAddress(this._port));
    }

    public void stop() {
        System.out.println("Shutting down");
        this._bossGroup.shutdownGracefully();
        this._workerGroup.shutdownGracefully();
    }

    public void waitForStop() throws InterruptedException {
        this._bossGroup.terminationFuture().await();
        this._workerGroup.terminationFuture().await();
    }

    private class StreamHandler
    extends SimpleChannelInboundHandler<RestRequest> {
        private StreamHandler() {
        }

        private void writeError(Channel ch, TransportResponse<StreamResponse> response, Throwable ex) {
            RestResponseBuilder responseBuilder = (RestResponseBuilder)new RestResponseBuilder(RestStatus.responseForError((int)RestStatus.INTERNAL_SERVER_ERROR, (Throwable)ex)).unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()));
            ch.writeAndFlush((Object)responseBuilder.build());
        }

        private void writeResponse(Channel ch, TransportResponse<StreamResponse> response, RestResponse restResponse) {
            RestResponseBuilder responseBuilder = (RestResponseBuilder)restResponse.builder().unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()));
            ch.writeAndFlush((Object)responseBuilder.build());
        }

        protected void channelRead0(ChannelHandlerContext ctx, RestRequest request) throws Exception {
            final Channel ch = ctx.channel();
            TransportCallback<StreamResponse> writeResponseCallback = new TransportCallback<StreamResponse>(){

                public void onResponse(final TransportResponse<StreamResponse> response) {
                    if (response.hasError()) {
                        StreamHandler.this.writeError(ch, (TransportResponse<StreamResponse>)response, response.getError());
                    } else {
                        Messages.toRestResponse((StreamResponse)((StreamResponse)response.getResponse()), (Callback)new Callback<RestResponse>(){

                            public void onError(Throwable e) {
                                StreamHandler.this.writeError(ch, (TransportResponse<StreamResponse>)response, e);
                            }

                            public void onSuccess(RestResponse result) {
                                StreamHandler.this.writeResponse(ch, (TransportResponse<StreamResponse>)response, result);
                            }
                        });
                    }
                }
            };
            try {
                HttpNettyServer.this._dispatcher.handleRequest(Messages.toStreamRequest((RestRequest)request), (TransportCallback)writeResponseCallback);
            }
            catch (Exception ex) {
                writeResponseCallback.onResponse(TransportResponseImpl.error((Throwable)ex, Collections.emptyMap()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOG.error("Exception caught on channel: " + ctx.channel().remoteAddress(), cause);
            ctx.close();
        }
    }

    private class RestHandler
    extends SimpleChannelInboundHandler<RestRequest> {
        private RestHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RestRequest request) throws Exception {
            final Channel ch = ctx.channel();
            TransportCallback<RestResponse> writeResponseCallback = new TransportCallback<RestResponse>(){

                public void onResponse(TransportResponse<RestResponse> response) {
                    RestResponseBuilder responseBuilder = response.hasError() ? new RestResponseBuilder(RestStatus.responseForError((int)RestStatus.INTERNAL_SERVER_ERROR, (Throwable)response.getError())) : new RestResponseBuilder((RestResponse)response.getResponse());
                    ((RestResponseBuilder)responseBuilder.unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()))).build();
                    ch.writeAndFlush((Object)responseBuilder.build());
                }
            };
            try {
                HttpNettyServer.this._dispatcher.handleRequest(request, (TransportCallback)writeResponseCallback);
            }
            catch (Exception ex) {
                writeResponseCallback.onResponse(TransportResponseImpl.error((Throwable)ex, Collections.emptyMap()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOG.error("Exception caught on channel: " + ctx.channel().remoteAddress(), cause);
            ctx.close();
        }
    }
}

