/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.DataObjectToObjectCache;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.lang.reflect.Constructor;

public class WrappingArrayTemplate<E extends DataTemplate<?>>
extends AbstractArrayTemplate<E> {
    protected final Constructor<E> _constructor;
    protected DataObjectToObjectCache<E> _cache;

    protected WrappingArrayTemplate(DataList list, ArrayDataSchema schema, Class<E> elementClass) throws TemplateOutputCastException {
        super(list, schema, elementClass, DataList.class);
        this._constructor = DataTemplateUtil.templateConstructor(elementClass, schema.getItems());
        this._cache = new DataObjectToObjectCache(this.data().size());
    }

    @Override
    public boolean add(E element) throws ClassCastException {
        Object unwrapped = this.unwrap(element);
        boolean result = this._list.add(unwrapped);
        this._cache.put(unwrapped, element);
        ++this.modCount;
        return result;
    }

    @Override
    public void add(int index, E element) throws ClassCastException {
        Object unwrapped = this.unwrap(element);
        this._list.add(index, unwrapped);
        this._cache.put(unwrapped, element);
        ++this.modCount;
    }

    @Override
    public E get(int index) throws TemplateOutputCastException {
        return this.cacheLookup(this._list.get(index), index);
    }

    @Override
    public E remove(int index) throws TemplateOutputCastException {
        Object removed = this._list.remove(index);
        ++this.modCount;
        return this.cacheLookup(removed, -1);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this._list.removeRange(fromIndex, toIndex);
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) throws ClassCastException, TemplateOutputCastException {
        Object replaced = this._list.set(index, this.unwrap(element));
        ++this.modCount;
        return this.cacheLookup(replaced, -1);
    }

    @Override
    public WrappingArrayTemplate<E> clone() throws CloneNotSupportedException {
        WrappingArrayTemplate clone = (WrappingArrayTemplate)super.clone();
        clone._cache = clone._cache.clone();
        return clone;
    }

    @Override
    public WrappingArrayTemplate<E> copy() throws CloneNotSupportedException {
        WrappingArrayTemplate copy = (WrappingArrayTemplate)super.copy();
        copy._cache = new DataObjectToObjectCache(copy.data().size());
        return copy;
    }

    protected Object unwrap(E object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        if (object.getClass() == this._elementClass) {
            return object.data();
        }
        throw new ClassCastException("Input " + object + " should be a " + this._elementClass.getName());
    }

    protected E cacheLookup(Object object, int index) throws TemplateOutputCastException {
        assert (object != null);
        DataTemplate wrapped = (DataTemplate)this._cache.get(object);
        if (wrapped == null || wrapped.data() != object) {
            wrapped = DataTemplateUtil.wrap(object, this._constructor);
            if (index != -1) {
                this._cache.put(object, wrapped);
            }
        }
        return (E)wrapped;
    }
}

