/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.resolver.InputStreamProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileDataSchemaLocation
implements DataSchemaLocation,
InputStreamProvider {
    private final File _file;
    private final String _path;

    public FileDataSchemaLocation(File file) {
        this._file = file;
        this._path = FileDataSchemaLocation.getFilePath(file);
    }

    @Override
    public File getSourceFile() {
        return this._file;
    }

    @Override
    public InputStream asInputStream(StringBuilder errorMessageBuilder) {
        FileInputStream inputStream = null;
        try {
            if (this._file.exists()) {
                inputStream = new FileInputStream(this._file);
            }
        }
        catch (FileNotFoundException exc) {
            errorMessageBuilder.append(this._path).append(" not found.\n");
        }
        return inputStream;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof FileDataSchemaLocation && this._path.equals(((FileDataSchemaLocation)o)._path);
    }

    public String toString() {
        return this._path;
    }

    private static String getFilePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }
}

