/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.validation.ValidationOptions;
import java.util.HashMap;
import java.util.Map;

public class SchemaParserFactory
implements DataSchemaParserFactory {
    private static final Map<ValidationOptions, SchemaParserFactory> factoryMap = new HashMap<ValidationOptions, SchemaParserFactory>();
    private final ValidationOptions _validationOptions;

    @Override
    public SchemaParser create(DataSchemaResolver resolver) {
        SchemaParser parser = new SchemaParser(resolver);
        if (this._validationOptions != null) {
            parser.setValidationOptions(this._validationOptions);
        }
        return parser;
    }

    @Override
    public String getLanguageExtension() {
        return "pdsc";
    }

    protected SchemaParserFactory(ValidationOptions validationOptions) {
        this._validationOptions = validationOptions;
    }

    public static final SchemaParserFactory instance() {
        return SchemaParserFactory.instance(null);
    }

    public static final SchemaParserFactory instance(ValidationOptions validationOptions) {
        if (factoryMap.containsKey(validationOptions)) {
            return factoryMap.get(validationOptions);
        }
        SchemaParserFactory factory = new SchemaParserFactory(validationOptions);
        factoryMap.put(validationOptions, factory);
        return factory;
    }
}

