/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.message;

import com.linkedin.data.message.Message;
import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;

public class MessageUtil {
    public static StringBuilder appendMessages(StringBuilder sb, Collection<? extends Message> messages) {
        Formatter formatter = new Formatter(sb);
        Appendable appendable = formatter.out();
        for (Message message : messages) {
            try {
                message.format(formatter, " :: ");
                appendable.append('\n');
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        formatter.flush();
        formatter.close();
        return sb;
    }

    public static String messagesToString(Collection<? extends Message> messages) {
        StringBuilder sb = new StringBuilder();
        return MessageUtil.appendMessages(sb, messages).toString();
    }

    public static boolean messagesContainsErrors(Collection<? extends Message> messages) {
        boolean error = false;
        for (Message message : messages) {
            if (!message.isError()) continue;
            error = true;
            break;
        }
        return error;
    }
}

