/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import com.linkedin.data.collections.CommonList;
import com.linkedin.data.collections.ListChecker;
import com.linkedin.data.collections.RefCounted;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CowList<E>
extends AbstractList<E>
implements CommonList<E>,
Cloneable {
    protected ListChecker<E> _checker;
    private boolean _readOnly = false;
    private RefCounted<InternalList<E>> _refCounted;

    public CowList() {
        this._checker = null;
        this._refCounted = new RefCounted(new InternalList());
    }

    public CowList(List<? extends E> list) {
        this._checker = null;
        this.checkAll(list);
        this._refCounted = new RefCounted<InternalList<? extends E>>(new InternalList<E>(list));
    }

    public CowList(int initialCapacity) {
        this._checker = null;
        this._refCounted = new RefCounted(new InternalList(initialCapacity));
    }

    public CowList(ListChecker<E> checker) {
        this._checker = checker;
        this._refCounted = new RefCounted(new InternalList());
    }

    public CowList(List<? extends E> list, ListChecker<E> checker) {
        this._checker = checker;
        this.checkAll(list);
        this._refCounted = new RefCounted<InternalList<? extends E>>(new InternalList<E>(list));
    }

    public CowList(int initialCapacity, ListChecker<E> checker) {
        this._checker = checker;
        this._refCounted = new RefCounted(new InternalList(initialCapacity));
    }

    @Override
    public boolean add(E e) {
        this.check(e);
        return this.getMutable().add(e);
    }

    @Override
    public void add(int index, E element) {
        this.check(element);
        this.getMutable().add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkAll(c);
        return this.getMutable().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkAll(c);
        return this.getMutable().addAll(index, c);
    }

    @Override
    public void clear() {
        this.getMutable().clear();
    }

    @Override
    public CowList<E> clone() throws CloneNotSupportedException {
        CowList o = (CowList)super.clone();
        o._refCounted = this._refCounted.acquire();
        o._readOnly = false;
        return o;
    }

    @Override
    public boolean contains(Object o) {
        return this.getObject().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getObject().containsAll(c);
    }

    @Override
    public boolean equals(Object object) {
        return this.getObject().equals(object);
    }

    @Override
    public E get(int index) {
        return this.getObject().get(index);
    }

    @Override
    public int hashCode() {
        return this.getObject().hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.getObject().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getObject().isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getObject().lastIndexOf(o);
    }

    @Override
    public E remove(int index) {
        return this.getMutable().remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.getMutable().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getMutable().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getMutable().retainAll(c);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.getMutable().removeRange(fromIndex, toIndex);
    }

    @Override
    public E set(int index, E element) {
        this.check(element);
        return this.getMutable().set(index, element);
    }

    @Override
    public int size() {
        return this.getObject().size();
    }

    @Override
    public Object[] toArray() {
        return this.getObject().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getObject().toArray(a);
    }

    @Override
    public String toString() {
        return this.getObject().toString();
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly() {
        this._readOnly = true;
    }

    @Override
    public void invalidate() {
        try {
            if (this._refCounted != null) {
                this._refCounted.release();
            }
        }
        finally {
            this._refCounted = null;
        }
    }

    protected boolean addWithoutChecking(E element) {
        return this.getMutable().add(element);
    }

    protected E setWithoutChecking(int index, E element) {
        return this.getMutable().set(index, element);
    }

    RefCounted<InternalList<E>> getRefCounted() {
        return this._refCounted;
    }

    private final void check(E e) {
        if (this._checker != null) {
            this._checker.check(this, e);
        }
    }

    private final void checkAll(Collection<? extends E> c) {
        if (this._checker != null) {
            for (E e : c) {
                this._checker.check(this, e);
            }
        }
    }

    private final InternalList<E> getMutable() {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Cannot mutate a read-only list");
        }
        this._refCounted = this._refCounted.getMutable();
        return this._refCounted.getObject();
    }

    protected final InternalList<E> getObject() {
        return this._refCounted.getObject();
    }

    private static class InternalList<E>
    extends ArrayList<E> {
        public InternalList() {
        }

        public InternalList(List<? extends E> l) {
            super(l);
        }

        public InternalList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

