/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.Data;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.codec.PsonDataCodec;
import com.linkedin.util.ArgumentUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ByteString {
    private static final PsonDataCodec PSON_DATA_CODEC = new PsonDataCodec();
    private static final JacksonDataCodec JACKSON_DATA_CODEC = new JacksonDataCodec();
    private static final ByteString EMPTY = new ByteString(new byte[0]);
    private final ByteArrayVector _byteArrays;

    public static ByteString empty() {
        return EMPTY;
    }

    public static ByteString unsafeWrap(byte[] bytes) {
        ArgumentUtil.notNull(bytes, "bytes");
        return bytes.length == 0 ? ByteString.empty() : new ByteString(bytes);
    }

    public static ByteString copy(byte[] bytes) {
        ArgumentUtil.notNull(bytes, "bytes");
        return bytes.length == 0 ? ByteString.empty() : new ByteString(Arrays.copyOf(bytes, bytes.length));
    }

    public static ByteString copy(byte[] bytes, int offset, int length) {
        ArgumentUtil.notNull(bytes, "bytes");
        ArgumentUtil.checkBounds(bytes.length, offset, length);
        return length == 0 ? ByteString.empty() : new ByteString(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    public static ByteString copy(ByteBuffer byteBuffer) {
        ArgumentUtil.notNull(byteBuffer, "byteBuffer");
        int size = byteBuffer.remaining();
        if (size == 0) {
            return ByteString.empty();
        }
        byte[] bytes = new byte[size];
        byteBuffer.get(bytes);
        return new ByteString(bytes);
    }

    public static ByteString copyString(String str, String charsetName) {
        return ByteString.copyString(str, Charset.forName(charsetName));
    }

    public static ByteString copyString(String str, Charset charset) {
        ArgumentUtil.notNull(str, "str");
        return ByteString.copy(str.getBytes(charset));
    }

    public static ByteString copyAvroString(String string, boolean validate) {
        ArgumentUtil.notNull(string, "string");
        if (string.length() == 0) {
            return ByteString.empty();
        }
        byte[] bytes = Data.stringToBytes(string, validate);
        if (bytes == null) {
            return null;
        }
        return new ByteString(bytes);
    }

    public static ByteString copyFromDataMapAsJson(DataMap dataMap) throws IOException {
        return new ByteString(JACKSON_DATA_CODEC.mapToBytes(dataMap));
    }

    public static ByteString copyFromDataMapAsPson(DataMap dataMap) throws IOException {
        return new ByteString(PSON_DATA_CODEC.mapToBytes(dataMap));
    }

    public static ByteString read(InputStream inputStream, int size) throws IOException {
        int bufIdx;
        int bytesRead;
        if (size == 0) {
            return ByteString.empty();
        }
        byte[] buf = new byte[size];
        for (bufIdx = 0; bufIdx < size && (bytesRead = inputStream.read(buf, bufIdx, size - bufIdx)) != -1; bufIdx += bytesRead) {
        }
        if (bufIdx != size) {
            throw new IOException("Insufficient data in InputStream, requested size " + size + ", read " + bufIdx);
        }
        return new ByteString(buf);
    }

    public static ByteString read(InputStream inputStream) throws IOException {
        int bytesRead;
        NoCopyByteArrayOutputStream bos = new NoCopyByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = inputStream.read(buf, 0, buf.length)) != -1) {
            bos.write(buf, 0, bytesRead);
        }
        return new ByteString(bos.getBytes(), 0, bos.getBytesCount());
    }

    private ByteString(byte[] bytes) {
        this(ArgumentUtil.ensureNotNull(bytes, "bytes"), 0, bytes.length);
    }

    private ByteString(byte[] bytes, int offset, int length) {
        ArgumentUtil.notNull(bytes, "bytes");
        ByteArray[] byteArrays = new ByteArray[]{new ByteArray(bytes, offset, length)};
        this._byteArrays = new ByteArrayVector(byteArrays);
    }

    private ByteString(ByteArrayVector byteArrays) {
        ArgumentUtil.notNull(byteArrays, "byteArrays");
        this._byteArrays = byteArrays;
    }

    public int length() {
        return this._byteArrays.getBytesNum();
    }

    public boolean isEmpty() {
        return this._byteArrays.getBytesNum() == 0;
    }

    public byte[] copyBytes() {
        byte[] result = new byte[this._byteArrays.getBytesNum()];
        this.copyBytes(result, 0);
        return result;
    }

    public void copyBytes(byte[] dest, int offset) {
        int position = offset;
        for (int i = 0; i < this._byteArrays.getArraySize(); ++i) {
            ByteArray byteArray = this._byteArrays.get(i);
            System.arraycopy(byteArray.getArray(), byteArray.getOffset(), dest, position, byteArray.getLength());
            position += byteArray.getLength();
        }
    }

    public ByteBuffer asByteBuffer() {
        ByteArray byteArray = this.assembleIfNeeded();
        return ByteBuffer.wrap(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength()).asReadOnlyBuffer();
    }

    public String asString(String charsetName) {
        return this.asString(Charset.forName(charsetName));
    }

    public String asString(Charset charset) {
        ByteArray byteArray = this.assembleIfNeeded();
        return new String(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength(), charset);
    }

    public String asAvroString() {
        ByteArray byteArray = this.assembleIfNeeded();
        return Data.bytesToString(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
    }

    public InputStream asInputStream() {
        return new ByteArrayVectorInputStream(this._byteArrays);
    }

    public void write(OutputStream out) throws IOException {
        for (int i = 0; i < this._byteArrays.getArraySize(); ++i) {
            ByteArray byteArray = this._byteArrays.get(i);
            out.write(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
        }
    }

    public List<ByteString> decompose() {
        ArrayList<ByteString> decomposedList = new ArrayList<ByteString>();
        for (int i = 0; i < this._byteArrays.getArraySize(); ++i) {
            ByteArray[] byteArrays = new ByteArray[]{this._byteArrays.get(i)};
            decomposedList.add(new ByteString(new ByteArrayVector(byteArrays)));
        }
        return decomposedList;
    }

    public ByteString slice(int offset, int length) {
        ArgumentUtil.checkBounds(this._byteArrays.getBytesNum(), offset, length);
        return new ByteString(this._byteArrays.slice(offset, length));
    }

    public ByteString copySlice(int offset, int length) {
        ArgumentUtil.checkBounds(this._byteArrays.getBytesNum(), offset, length);
        return new ByteString(this.slice(offset, length).copyBytes());
    }

    public boolean startsWith(byte[] prefixBytes) {
        if (prefixBytes.length == 0) {
            return true;
        }
        if (prefixBytes.length > this._byteArrays._totalLength) {
            return false;
        }
        return this.slice(0, prefixBytes.length).equals(new ByteString(prefixBytes));
    }

    public int indexOfBytes(byte[] targetBytes) {
        if (targetBytes.length == 0) {
            return 0;
        }
        if (targetBytes.length > this._byteArrays._totalLength) {
            return -1;
        }
        ByteIterator byteIterator = new ByteIterator();
        ByteIterator resumeByteIterator = byteIterator.copy();
        resumeByteIterator.next();
        int i = 0;
        while (i < targetBytes.length) {
            if (byteIterator.isFinished()) {
                return -1;
            }
            byte b = byteIterator.getCurrentByte();
            if (b != targetBytes[i]) {
                i = 0;
                byteIterator = resumeByteIterator;
                resumeByteIterator = resumeByteIterator.copy();
                resumeByteIterator.next();
                continue;
            }
            ++i;
            byteIterator.next();
        }
        return byteIterator.currentIndex() - targetBytes.length;
    }

    public byte getByte(int offset) {
        return this._byteArrays.getByte(offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        int length = this.length();
        if (length != that.length()) {
            return false;
        }
        int arrayIndex = 0;
        int arrayOffset = 0;
        int thatArrayIndex = 0;
        int thatArrayOffset = 0;
        for (int pos = 0; pos < length; ++pos) {
            if (this._byteArrays.get(arrayIndex).get(arrayOffset) != that._byteArrays.get(thatArrayIndex).get(thatArrayOffset)) {
                return false;
            }
            ++thatArrayOffset;
            if (++arrayOffset == this._byteArrays.get(arrayIndex).getLength()) {
                ++arrayIndex;
                arrayOffset = 0;
            }
            if (thatArrayOffset != that._byteArrays.get(thatArrayIndex).getLength()) continue;
            ++thatArrayIndex;
            thatArrayOffset = 0;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int index = 0; index < this._byteArrays.getArraySize(); ++index) {
            for (int offset = 0; offset < this._byteArrays.get(index).getLength(); ++offset) {
                result = result * 31 + this._byteArrays.get(index).get(offset);
            }
        }
        return result;
    }

    public String toString() {
        int NUM_BYTES = 4;
        StringBuilder sb = new StringBuilder();
        sb.append("ByteString(length=");
        sb.append(this.length());
        if (this.length() > 0) {
            int i;
            sb.append(",bytes=");
            for (i = 0; i < Math.min(this.length(), 4); ++i) {
                sb.append(String.format("%02x", this._byteArrays.getByte(i) & 0xFF));
            }
            if (this.length() > 8) {
                sb.append("...");
            }
            for (i = Math.max(4, this.length() - 4); i < this.length(); ++i) {
                sb.append(String.format("%02x", this._byteArrays.getByte(i) & 0xFF));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private ByteArray assembleIfNeeded() {
        if (this._byteArrays.getArraySize() == 1) {
            return this._byteArrays.get(0);
        }
        return new ByteArray(this.copyBytes(), 0, this._byteArrays.getBytesNum());
    }

    private static class ByteArrayVectorInputStream
    extends InputStream {
        private final ByteArrayVector _byteArrays;
        private int _pos;
        private int _arrayIndex;
        private int _arrayOffset;
        private int _mark;
        private int _count;

        ByteArrayVectorInputStream(ByteArrayVector byteArrays) {
            this._byteArrays = byteArrays;
            this._count = this._byteArrays.getBytesNum();
            this._mark = this._pos = 0;
            this._arrayIndex = 0;
            this._arrayOffset = 0;
        }

        @Override
        public int available() {
            return this._count - this._pos;
        }

        @Override
        public void mark(int readLimit) {
            this._mark = this._pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (this._pos < this._count) {
                ++this._pos;
                byte result = this._byteArrays.get(this._arrayIndex).get(this._arrayOffset);
                ++this._arrayOffset;
                if (this._arrayOffset == this._byteArrays.get(this._arrayIndex).getLength()) {
                    ++this._arrayIndex;
                    this._arrayOffset = 0;
                }
                return result & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) {
            int len;
            if (this._pos >= this._count) {
                return -1;
            }
            int numBytes = Math.min(this._count - this._pos, length);
            for (int copiedBytesNum = 0; copiedBytesNum < numBytes; copiedBytesNum += len) {
                ByteArray byteArray = this._byteArrays.get(this._arrayIndex);
                len = Math.min(byteArray.getLength() - this._arrayOffset, numBytes - copiedBytesNum);
                System.arraycopy(byteArray.getArray(), byteArray.getOffset() + this._arrayOffset, buffer, offset + copiedBytesNum, len);
                if (len == byteArray.getLength() - this._arrayOffset) {
                    ++this._arrayIndex;
                    this._arrayOffset = 0;
                    continue;
                }
                this._arrayOffset += len;
            }
            this._pos += numBytes;
            return numBytes;
        }

        @Override
        public void reset() {
            this._pos = this._mark;
            this._arrayIndex = this._byteArrays.locate(this._pos, 0, this._byteArrays.getArraySize());
            this._arrayOffset = this._pos - this._byteArrays._accumulatedLens[this._arrayIndex];
        }

        @Override
        public long skip(long num) {
            long numBytes = Math.min((long)(this._count - this._pos), num < 0L ? 0L : num);
            this._pos = (int)((long)this._pos + numBytes);
            this._arrayIndex = this._byteArrays.locate(this._pos, 0, this._byteArrays.getArraySize());
            this._arrayOffset = this._pos - this._byteArrays._accumulatedLens[this._arrayIndex];
            return numBytes;
        }
    }

    private static class ByteArrayVector {
        private final ByteArray[] _byteArrays;
        private final int[] _accumulatedLens;
        private final int _totalLength;

        ByteArrayVector(ByteArray[] byteArrays) {
            this._byteArrays = byteArrays;
            int arrayNum = this._byteArrays.length;
            this._accumulatedLens = new int[arrayNum];
            int accuLen = 0;
            for (int i = 0; i < arrayNum; ++i) {
                this._accumulatedLens[i] = accuLen;
                accuLen += this._byteArrays[i].getLength();
            }
            this._totalLength = accuLen;
        }

        ByteArray get(int i) {
            if (i >= this._byteArrays.length || i < 0) {
                throw new IndexOutOfBoundsException("i: " + i);
            }
            return this._byteArrays[i];
        }

        byte getByte(int offset) {
            if (offset >= this._totalLength || offset < 0) {
                throw new IndexOutOfBoundsException("offset: " + offset);
            }
            int index = this.locate(offset, 0, this._byteArrays.length - 1);
            return this._byteArrays[index].get(offset - this._accumulatedLens[index]);
        }

        ByteArrayVector slice(int offset, int length) {
            ByteArray[] byteArrays;
            ArgumentUtil.checkBounds(this._totalLength, offset, length);
            int startIndex = this.locate(offset, 0, this._byteArrays.length - 1);
            int endIndex = this.locate(offset + length, startIndex, this._byteArrays.length - 1);
            if (startIndex == endIndex) {
                byteArrays = new ByteArray[]{this._byteArrays[startIndex].slice(offset - this._accumulatedLens[startIndex], length)};
            } else {
                int arrayLen = endIndex - startIndex + 1;
                byteArrays = new ByteArray[arrayLen];
                byteArrays[0] = this._byteArrays[startIndex].slice(offset - this._accumulatedLens[startIndex]);
                byteArrays[arrayLen - 1] = this._byteArrays[endIndex].slice(0, offset + length - this._accumulatedLens[endIndex]);
                for (int i = 1; i < arrayLen - 1; ++i) {
                    byteArrays[i] = this._byteArrays[startIndex + i];
                }
            }
            return new ByteArrayVector(byteArrays);
        }

        int getBytesNum() {
            return this._totalLength;
        }

        int getArraySize() {
            return this._byteArrays.length;
        }

        private int locate(int i, int startIndex, int endIndex) {
            if (startIndex > endIndex) {
                throw new IllegalArgumentException("location " + i + " is out of bound");
            }
            int mid = (startIndex + endIndex) / 2;
            if (this._accumulatedLens[mid] > i) {
                return this.locate(i, startIndex, mid - 1);
            }
            if (this._accumulatedLens[mid] == i) {
                return mid;
            }
            if (mid == endIndex || this._accumulatedLens[mid + 1] > i) {
                return mid;
            }
            return this.locate(i, mid + 1, endIndex);
        }
    }

    private static class ByteArray {
        private final byte[] _bytes;
        private final int _offset;
        private final int _length;

        ByteArray(byte[] bytes, int offset, int length) {
            ArgumentUtil.notNull(bytes, "bytes");
            ArgumentUtil.checkBounds(bytes.length, offset, length);
            this._bytes = bytes;
            this._offset = offset;
            this._length = length;
        }

        byte[] getArray() {
            return this._bytes;
        }

        int getOffset() {
            return this._offset;
        }

        int getLength() {
            return this._length;
        }

        byte get(int i) {
            if (i >= this._length || i < 0) {
                throw new IndexOutOfBoundsException("i: " + i);
            }
            return this._bytes[this._offset + i];
        }

        ByteArray slice(int offset, int length) {
            ArgumentUtil.checkBounds(this._length, offset, length);
            return new ByteArray(this._bytes, this._offset + offset, length);
        }

        ByteArray slice(int offset) {
            if (offset > this._length || offset < 0) {
                throw new IndexOutOfBoundsException("offset: " + offset);
            }
            return new ByteArray(this._bytes, this._offset + offset, this._length - offset);
        }
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private NoCopyByteArrayOutputStream() {
        }

        byte[] getBytes() {
            return this.buf;
        }

        int getBytesCount() {
            return this.count;
        }
    }

    public static class Builder {
        private final List<ByteString> _chunks = new ArrayList<ByteString>();

        public Builder append(ByteString dataChunk) {
            ArgumentUtil.notNull(dataChunk, "dataChunk");
            if (!EMPTY.equals(dataChunk)) {
                this._chunks.add(dataChunk);
            }
            return this;
        }

        public ByteString build() {
            if (this._chunks.isEmpty()) {
                return ByteString.empty();
            }
            if (this._chunks.size() == 1) {
                return this._chunks.get(0);
            }
            int totalByteArraySize = 0;
            for (ByteString chunk : this._chunks) {
                totalByteArraySize += chunk._byteArrays.getArraySize();
            }
            ByteArray[] byteArrays = new ByteArray[totalByteArraySize];
            int index = 0;
            for (ByteString chunk : this._chunks) {
                for (int i = 0; i < chunk._byteArrays.getArraySize(); ++i) {
                    byteArrays[index] = chunk._byteArrays.get(i);
                    ++index;
                }
            }
            return new ByteString(new ByteArrayVector(byteArrays));
        }
    }

    private class ByteIterator {
        private int _currentByteArray;
        private int _currentByteIndex;
        private boolean _finished;

        private ByteIterator() {
            this._currentByteArray = 0;
            this._currentByteIndex = 0;
            this._finished = false;
        }

        private ByteIterator(ByteIterator byteIterator) {
            this._currentByteArray = byteIterator._currentByteArray;
            this._currentByteIndex = byteIterator._currentByteIndex;
            this._finished = byteIterator._finished;
        }

        private ByteIterator copy() {
            return new ByteIterator(this);
        }

        private void next() {
            ++this._currentByteIndex;
            if (this._currentByteIndex == ByteString.this._byteArrays.get(this._currentByteArray)._length) {
                if (this._currentByteArray + 1 == ByteString.this._byteArrays.getArraySize()) {
                    this._finished = true;
                    return;
                }
                ++this._currentByteArray;
                this._currentByteIndex = 0;
            }
        }

        private byte getCurrentByte() {
            return ByteString.this._byteArrays.get(this._currentByteArray).get(this._currentByteIndex);
        }

        private boolean isFinished() {
            return this._finished;
        }

        private int currentIndex() {
            int totalLengthCovered = 0;
            for (int m = 0; m < this._currentByteArray; ++m) {
                totalLengthCovered += ByteString.this._byteArrays.get(m)._length;
            }
            return totalLengthCovered += this._currentByteIndex;
        }
    }
}

