/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import java.util.List;
import parquet.io.InvalidRecordException;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.TypeConverter;
import parquet.schema.TypeVisitor;

public abstract class Type {
    private final String name;
    private final Repetition repetition;
    private final OriginalType originalType;

    public Type(String name, Repetition repetition) {
        this(name, repetition, null);
    }

    public Type(String name, Repetition repetition, OriginalType originalType) {
        this.name = name;
        this.repetition = repetition;
        this.originalType = originalType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRepetition(Repetition rep) {
        return this.repetition == rep;
    }

    public Repetition getRepetition() {
        return this.repetition;
    }

    public OriginalType getOriginalType() {
        return this.originalType;
    }

    public abstract boolean isPrimitive();

    public GroupType asGroupType() {
        if (this.isPrimitive()) {
            throw new ClassCastException(this + " is not a group");
        }
        return (GroupType)this;
    }

    public PrimitiveType asPrimitiveType() {
        if (!this.isPrimitive()) {
            throw new ClassCastException(this + " is not a primititve");
        }
        return (PrimitiveType)this;
    }

    public abstract void writeToStringBuilder(StringBuilder var1, String var2);

    public abstract void accept(TypeVisitor var1);

    public int hashCode() {
        return this.typeHashCode();
    }

    protected abstract int typeHashCode();

    protected abstract boolean typeEquals(Type var1);

    public boolean equals(Object other) {
        if (!(other instanceof Type) || other == null) {
            return false;
        }
        return this.typeEquals((Type)other);
    }

    protected abstract int getMaxRepetitionLevel(String[] var1, int var2);

    protected abstract int getMaxDefinitionLevel(String[] var1, int var2);

    protected abstract Type getType(String[] var1, int var2);

    protected abstract List<String[]> getPaths(int var1);

    protected abstract boolean containsPath(String[] var1, int var2);

    protected abstract Type union(Type var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeToStringBuilder(sb, "");
        return sb.toString();
    }

    void checkContains(Type subType) {
        if (!this.name.equals(subType.name) || this.repetition != subType.repetition) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
    }

    abstract <T> T convert(List<GroupType> var1, TypeConverter<T> var2);

    public static enum Repetition {
        REQUIRED{

            @Override
            public boolean isMoreRestrictiveThan(Repetition other) {
                return other != REQUIRED;
            }
        }
        ,
        OPTIONAL{

            @Override
            public boolean isMoreRestrictiveThan(Repetition other) {
                return other == REPEATED;
            }
        }
        ,
        REPEATED{

            @Override
            public boolean isMoreRestrictiveThan(Repetition other) {
                return false;
            }
        };


        public abstract boolean isMoreRestrictiveThan(Repetition var1);
    }
}

