/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import javax.jdo.spi.StateInterrogation;
import javax.jdo.spi.StateManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.ErrorHandler;

public class JDOImplHelper {
    private static Map registeredClasses = Collections.synchronizedMap(new HashMap());
    private static Map authorizedStateManagerClasses = new WeakHashMap();
    private static List listeners = new ArrayList();
    private static List stateInterrogations = new ArrayList();
    private static JDOImplHelper jdoImplHelper = new JDOImplHelper();
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private static String dateFormatPattern;
    private static DateFormat dateFormat;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static ErrorHandler errorHandler;
    static Map stringConstructorMap;

    private JDOImplHelper() {
    }

    public static JDOImplHelper getInstance() throws SecurityException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(JDOPermission.GET_METADATA);
        }
        return jdoImplHelper;
    }

    public String[] getFieldNames(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldNames();
    }

    public Class[] getFieldTypes(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldTypes();
    }

    public byte[] getFieldFlags(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldFlags();
    }

    public Class getPersistenceCapableSuperclass(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getPersistenceCapableSuperclass();
    }

    public PersistenceCapable newInstance(Class pcClass, StateManager sm) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewInstance(sm);
    }

    public PersistenceCapable newInstance(Class pcClass, StateManager sm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewInstance(sm, oid);
    }

    public Object newObjectIdInstance(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class pcClass, Object obj) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewObjectIdInstance(obj);
    }

    public void copyKeyFieldsToObjectId(Class pcClass, PersistenceCapable.ObjectIdFieldSupplier fm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", pcClass.getName()));
        }
        pcInstance.jdoCopyKeyFieldsToObjectId(fm, oid);
    }

    public void copyKeyFieldsFromObjectId(Class pcClass, PersistenceCapable.ObjectIdFieldConsumer fm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", pcClass.getName()));
        }
        pcInstance.jdoCopyKeyFieldsFromObjectId(fm, oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(Class pcClass, String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistenceCapableSuperclass, PersistenceCapable pc) {
        if (pcClass == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        Meta meta = new Meta(fieldNames, fieldTypes, fieldFlags, persistenceCapableSuperclass, pc);
        registeredClasses.put(pcClass, meta);
        List list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                RegisterClassEvent event = new RegisterClassEvent(jdoImplHelper, pcClass, fieldNames, fieldTypes, fieldFlags, persistenceCapableSuperclass);
                for (RegisterClassListener crl : listeners) {
                    if (crl == null) continue;
                    crl.registerClass(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClasses(ClassLoader cl) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(JDOPermission.MANAGE_METADATA);
        }
        Map map = registeredClasses;
        synchronized (map) {
            Iterator i = registeredClasses.keySet().iterator();
            while (i.hasNext()) {
                Class pcClass = (Class)i.next();
                if (pcClass == null || pcClass.getClassLoader() != cl) continue;
                i.remove();
            }
        }
    }

    public void unregisterClass(Class pcClass) {
        if (pcClass == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(JDOPermission.MANAGE_METADATA);
        }
        registeredClasses.remove(pcClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisterClassListener(RegisterClassListener crl) {
        HashSet alreadyRegisteredClasses = null;
        List list = listeners;
        synchronized (list) {
            listeners.add(crl);
            alreadyRegisteredClasses = new HashSet(registeredClasses.keySet());
        }
        for (Class pcClass : alreadyRegisteredClasses) {
            Meta meta = JDOImplHelper.getMeta(pcClass);
            RegisterClassEvent event = new RegisterClassEvent(this, pcClass, meta.getFieldNames(), meta.getFieldTypes(), meta.getFieldFlags(), meta.getPersistenceCapableSuperclass());
            crl.registerClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisterClassListener(RegisterClassListener crl) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(crl);
        }
    }

    public Collection getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    private static Meta getMeta(Class pcClass) {
        Meta ret = (Meta)registeredClasses.get(pcClass);
        if (ret == null) {
            throw new JDOFatalUserException(msg.msg("ERR_NoMetadata", pcClass.getName()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClass(Class smClass) throws SecurityException {
        if (smClass == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(JDOPermission.SET_STATE_MANAGER);
        }
        Map map = authorizedStateManagerClasses;
        synchronized (map) {
            authorizedStateManagerClasses.put(smClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClasses(Collection smClasses) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(JDOPermission.SET_STATE_MANAGER);
            Map map = authorizedStateManagerClasses;
            synchronized (map) {
                Iterator it = smClasses.iterator();
                while (it.hasNext()) {
                    Object smClass = it.next();
                    if (!(smClass instanceof Class)) {
                        throw new ClassCastException(msg.msg("ERR_StateManagerClassCast", smClass.getClass().getName()));
                    }
                    JDOImplHelper.registerAuthorizedStateManagerClass((Class)it.next());
                }
            }
        }
    }

    public synchronized void registerDocumentBuilderFactory(DocumentBuilderFactory factory) {
        documentBuilderFactory = factory;
    }

    public static DocumentBuilderFactory getRegisteredDocumentBuilderFactory() {
        return documentBuilderFactory;
    }

    public synchronized void registerErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static ErrorHandler getRegisteredErrorHandler() {
        return errorHandler;
    }

    public static void checkAuthorizedStateManager(StateManager sm) {
        JDOImplHelper.checkAuthorizedStateManagerClass(sm.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAuthorizedStateManagerClass(Class smClass) {
        SecurityManager scm = System.getSecurityManager();
        if (scm == null) {
            return;
        }
        Map map = authorizedStateManagerClasses;
        synchronized (map) {
            if (authorizedStateManagerClasses.containsKey(smClass)) {
                return;
            }
        }
        scm.checkPermission(JDOPermission.SET_STATE_MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerStringConstructor(Class cls, StringConstructor sc) {
        Map map = stringConstructorMap;
        synchronized (map) {
            return stringConstructorMap.put(cls, sc);
        }
    }

    private static Locale getLocale(String s) {
        String lang = s;
        int firstUnderbar = s.indexOf(95);
        if (firstUnderbar == -1) {
            return new Locale(lang);
        }
        lang = s.substring(0, firstUnderbar);
        int secondUnderbar = s.indexOf(95, firstUnderbar + 1);
        if (secondUnderbar == -1) {
            String country = s.substring(firstUnderbar + 1);
            return new Locale(lang, country);
        }
        String country = s.substring(firstUnderbar + 1, secondUnderbar);
        String variant = s.substring(secondUnderbar + 1);
        return new Locale(lang, country, variant);
    }

    private static boolean isClassLoadable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object construct(String className, String keyString) {
        try {
            StringConstructor stringConstructor;
            Class<?> keyClass = Class.forName(className);
            Map map = stringConstructorMap;
            synchronized (map) {
                stringConstructor = (StringConstructor)stringConstructorMap.get(keyClass);
            }
            if (stringConstructor != null) {
                return stringConstructor.construct(keyString);
            }
            Constructor<?> keyConstructor = keyClass.getConstructor(String.class);
            return keyConstructor.newInstance(keyString);
        }
        catch (JDOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstruction", new Object[]{ex.toString(), className, keyString}), ex);
        }
    }

    static DateFormat getDateTimeInstance() {
        DateFormat result = null;
        try {
            result = (DateFormat)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return DateFormat.getDateTimeInstance();
                }
            });
        }
        catch (Exception ex) {
            result = DateFormat.getInstance();
        }
        return result;
    }

    public synchronized void registerDateFormat(DateFormat df) {
        dateFormat = df;
        dateFormatPattern = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : msg.msg("MSG_unknown");
    }

    public synchronized void addStateInterrogation(StateInterrogation si) {
        ArrayList<StateInterrogation> newList = new ArrayList<StateInterrogation>(stateInterrogations);
        newList.add(si);
        stateInterrogations = newList;
    }

    public synchronized void removeStateInterrogation(StateInterrogation si) {
        ArrayList newList = new ArrayList(stateInterrogations);
        newList.remove(si);
        stateInterrogations = newList;
    }

    private synchronized Iterator getStateInterrogationIterator() {
        return stateInterrogations.iterator();
    }

    public void nonBinaryCompatibleMakeDirty(Object pc, String fieldName) {
        Iterator sit = this.getStateInterrogationIterator();
        while (sit.hasNext()) {
            StateInterrogation si = (StateInterrogation)sit.next();
            try {
                if (!si.makeDirty(pc, fieldName)) continue;
                return;
            }
            catch (Throwable t) {
            }
        }
    }

    public boolean nonBinaryCompatibleIs(Object pc, StateInterrogationBooleanReturn sibr) {
        Iterator sit = this.getStateInterrogationIterator();
        while (sit.hasNext()) {
            Boolean result;
            StateInterrogation si = (StateInterrogation)sit.next();
            try {
                result = sibr.is(pc, si);
            }
            catch (Throwable t) {
                continue;
            }
            if (result == null) continue;
            return result;
        }
        return false;
    }

    public Object nonBinaryCompatibleGet(Object pc, StateInterrogationObjectReturn sibr) {
        Iterator sit = this.getStateInterrogationIterator();
        while (sit.hasNext()) {
            Object result;
            StateInterrogation si = (StateInterrogation)sit.next();
            try {
                result = sibr.get(pc, si);
            }
            catch (Throwable t) {
                continue;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static {
        jdoImplHelper.registerDateFormat(JDOImplHelper.getDateTimeInstance());
        stringConstructorMap = new HashMap();
        JDOImplHelper helper = JDOImplHelper.getInstance();
        if (JDOImplHelper.isClassLoadable("java.util.Currency")) {
            helper.registerStringConstructor(Currency.class, new StringConstructor(){

                public Object construct(String s) {
                    try {
                        return Currency.getInstance(s);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new JDOUserException(msg.msg("EXC_CurrencyStringConstructorIllegalArgument", s), ex);
                    }
                    catch (Exception ex) {
                        throw new JDOUserException(msg.msg("EXC_CurrencyStringConstructorException"), ex);
                    }
                }
            });
        }
        helper.registerStringConstructor(Locale.class, new StringConstructor(){

            public Object construct(String s) {
                try {
                    return JDOImplHelper.getLocale(s);
                }
                catch (Exception ex) {
                    throw new JDOUserException(msg.msg("EXC_LocaleStringConstructorException"), ex);
                }
            }
        });
        helper.registerStringConstructor(Date.class, new StringConstructor(){

            public synchronized Object construct(String s) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException ex) {
                    ParsePosition pp = new ParsePosition(0);
                    Date result = dateFormat.parse(s, pp);
                    if (result == null) {
                        throw new JDOUserException(msg.msg("EXC_DateStringConstructor", new Object[]{s, new Integer(pp.getErrorIndex()), dateFormatPattern}));
                    }
                    return result;
                }
            }
        });
    }

    public static interface StateInterrogationObjectReturn {
        public Object get(Object var1, StateInterrogation var2);
    }

    public static interface StateInterrogationBooleanReturn {
        public Boolean is(Object var1, StateInterrogation var2);
    }

    static class Meta {
        String[] fieldNames;
        Class[] fieldTypes;
        byte[] fieldFlags;
        Class persistenceCapableSuperclass;
        PersistenceCapable pc;

        Meta(String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistenceCapableSuperclass, PersistenceCapable pc) {
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.fieldFlags = fieldFlags;
            this.persistenceCapableSuperclass = persistenceCapableSuperclass;
            this.pc = pc;
        }

        String[] getFieldNames() {
            return this.fieldNames;
        }

        Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        Class getPersistenceCapableSuperclass() {
            return this.persistenceCapableSuperclass;
        }

        PersistenceCapable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }

    public static interface StringConstructor {
        public Object construct(String var1);
    }
}

