/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.rest.QueryIdTypeEnum;
import org.apache.gobblin.rest.QueryListType;
import org.apache.gobblin.rest.Table;
import org.apache.gobblin.rest.TimeRange;

public class JobExecutionQuery
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobExecutionQuery\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin job execution query\",\"fields\":[{\"name\":\"id\",\"type\":[\"string\",{\"type\":\"record\",\"name\":\"Table\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},{\"type\":\"enum\",\"name\":\"QueryListType\",\"doc\":\"Listing distinct jobs fetches the most recent execution info for each job name in the database. Listing recent jobs fetches the most recent job executions, regardless of job name.\",\"symbols\":[\"DISTINCT\",\"RECENT\"]}],\"doc\":\"Query ID (a job ID, job name, table definition, or list type)\"},{\"name\":\"idType\",\"type\":{\"type\":\"enum\",\"name\":\"QueryIdTypeEnum\",\"symbols\":[\"JOB_NAME\",\"JOB_ID\",\"TABLE\",\"LIST_TYPE\"]},\"doc\":\"Query ID type\"},{\"name\":\"timeRange\",\"type\":{\"type\":\"record\",\"name\":\"TimeRange\",\"doc\":\"Query time range\",\"fields\":[{\"name\":\"startTime\",\"type\":\"string\",\"doc\":\"Start time of the query range\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"string\",\"doc\":\"End time of the query range\",\"optional\":true},{\"name\":\"timeFormat\",\"type\":\"string\",\"doc\":\"Date/time format used to parse the start time and end time\"}]},\"doc\":\"Query time range\",\"optional\":true},{\"name\":\"limit\",\"type\":\"int\",\"doc\":\"Query limit\",\"default\":1,\"optional\":true},{\"name\":\"jobProperties\",\"type\":\"string\",\"doc\":\"Comma-separated list of job properties to include in the query result\",\"optional\":true},{\"name\":\"taskProperties\",\"type\":\"string\",\"doc\":\"Comma-separated list of task properties to include in the query result\",\"optional\":true},{\"name\":\"includeJobMetrics\",\"type\":\"boolean\",\"doc\":\"true/false if the response should include job metrics (default: true)\",\"default\":true,\"optional\":true},{\"name\":\"includeTaskMetrics\",\"type\":\"boolean\",\"doc\":\"true/false if the response should include task metrics (default: true)\",\"default\":true,\"optional\":true},{\"name\":\"includeTaskExecutions\",\"type\":\"boolean\",\"doc\":\"true/false if the response should include task executions (default: true)\",\"default\":true,\"optional\":true},{\"name\":\"includeJobsWithoutTasks\",\"type\":\"boolean\",\"doc\":\"true/false if the response should include jobs that did not launch tasks (default: true)\",\"default\":true,\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_IdType = SCHEMA.getField("idType");
    private static final RecordDataSchema.Field FIELD_TimeRange = SCHEMA.getField("timeRange");
    private static final RecordDataSchema.Field FIELD_Limit = SCHEMA.getField("limit");
    private static final RecordDataSchema.Field FIELD_JobProperties = SCHEMA.getField("jobProperties");
    private static final RecordDataSchema.Field FIELD_TaskProperties = SCHEMA.getField("taskProperties");
    private static final RecordDataSchema.Field FIELD_IncludeJobMetrics = SCHEMA.getField("includeJobMetrics");
    private static final RecordDataSchema.Field FIELD_IncludeTaskMetrics = SCHEMA.getField("includeTaskMetrics");
    private static final RecordDataSchema.Field FIELD_IncludeTaskExecutions = SCHEMA.getField("includeTaskExecutions");
    private static final RecordDataSchema.Field FIELD_IncludeJobsWithoutTasks = SCHEMA.getField("includeJobsWithoutTasks");

    public JobExecutionQuery() {
        super(new DataMap(), SCHEMA);
    }

    public JobExecutionQuery(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasId() {
        return this.contains(FIELD_Id);
    }

    public void removeId() {
        this.remove(FIELD_Id);
    }

    public Id getId(GetMode mode) {
        return (Id)this.obtainWrapped(FIELD_Id, Id.class, mode);
    }

    @Nonnull
    public Id getId() {
        return (Id)this.obtainWrapped(FIELD_Id, Id.class, GetMode.STRICT);
    }

    public JobExecutionQuery setId(Id value, SetMode mode) {
        this.putWrapped(FIELD_Id, Id.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionQuery setId(@Nonnull Id value) {
        this.putWrapped(FIELD_Id, Id.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIdType() {
        return this.contains(FIELD_IdType);
    }

    public void removeIdType() {
        this.remove(FIELD_IdType);
    }

    public QueryIdTypeEnum getIdType(GetMode mode) {
        return (QueryIdTypeEnum)((Object)this.obtainDirect(FIELD_IdType, QueryIdTypeEnum.class, mode));
    }

    @Nonnull
    public QueryIdTypeEnum getIdType() {
        return (QueryIdTypeEnum)((Object)this.obtainDirect(FIELD_IdType, QueryIdTypeEnum.class, GetMode.STRICT));
    }

    public JobExecutionQuery setIdType(QueryIdTypeEnum value, SetMode mode) {
        this.putDirect(FIELD_IdType, QueryIdTypeEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public JobExecutionQuery setIdType(@Nonnull QueryIdTypeEnum value) {
        this.putDirect(FIELD_IdType, QueryIdTypeEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTimeRange() {
        return this.contains(FIELD_TimeRange);
    }

    public void removeTimeRange() {
        this.remove(FIELD_TimeRange);
    }

    public TimeRange getTimeRange(GetMode mode) {
        return (TimeRange)this.obtainWrapped(FIELD_TimeRange, TimeRange.class, mode);
    }

    @Nullable
    public TimeRange getTimeRange() {
        return (TimeRange)this.obtainWrapped(FIELD_TimeRange, TimeRange.class, GetMode.STRICT);
    }

    public JobExecutionQuery setTimeRange(TimeRange value, SetMode mode) {
        this.putWrapped(FIELD_TimeRange, TimeRange.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionQuery setTimeRange(@Nonnull TimeRange value) {
        this.putWrapped(FIELD_TimeRange, TimeRange.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLimit() {
        return this.contains(FIELD_Limit);
    }

    public void removeLimit() {
        this.remove(FIELD_Limit);
    }

    public Integer getLimit(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_Limit, Integer.class, mode);
    }

    @Nullable
    public Integer getLimit() {
        return (Integer)this.obtainDirect(FIELD_Limit, Integer.class, GetMode.STRICT);
    }

    public JobExecutionQuery setLimit(Integer value, SetMode mode) {
        this.putDirect(FIELD_Limit, Integer.class, Integer.class, value, mode);
        return this;
    }

    public JobExecutionQuery setLimit(@Nonnull Integer value) {
        this.putDirect(FIELD_Limit, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery setLimit(int value) {
        this.putDirect(FIELD_Limit, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobProperties() {
        return this.contains(FIELD_JobProperties);
    }

    public void removeJobProperties() {
        this.remove(FIELD_JobProperties);
    }

    public String getJobProperties(GetMode mode) {
        return (String)this.obtainDirect(FIELD_JobProperties, String.class, mode);
    }

    @Nullable
    public String getJobProperties() {
        return (String)this.obtainDirect(FIELD_JobProperties, String.class, GetMode.STRICT);
    }

    public JobExecutionQuery setJobProperties(String value, SetMode mode) {
        this.putDirect(FIELD_JobProperties, String.class, String.class, value, mode);
        return this;
    }

    public JobExecutionQuery setJobProperties(@Nonnull String value) {
        this.putDirect(FIELD_JobProperties, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTaskProperties() {
        return this.contains(FIELD_TaskProperties);
    }

    public void removeTaskProperties() {
        this.remove(FIELD_TaskProperties);
    }

    public String getTaskProperties(GetMode mode) {
        return (String)this.obtainDirect(FIELD_TaskProperties, String.class, mode);
    }

    @Nullable
    public String getTaskProperties() {
        return (String)this.obtainDirect(FIELD_TaskProperties, String.class, GetMode.STRICT);
    }

    public JobExecutionQuery setTaskProperties(String value, SetMode mode) {
        this.putDirect(FIELD_TaskProperties, String.class, String.class, value, mode);
        return this;
    }

    public JobExecutionQuery setTaskProperties(@Nonnull String value) {
        this.putDirect(FIELD_TaskProperties, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIncludeJobMetrics() {
        return this.contains(FIELD_IncludeJobMetrics);
    }

    public void removeIncludeJobMetrics() {
        this.remove(FIELD_IncludeJobMetrics);
    }

    public Boolean isIncludeJobMetrics(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_IncludeJobMetrics, Boolean.class, mode);
    }

    @Nullable
    public Boolean isIncludeJobMetrics() {
        return (Boolean)this.obtainDirect(FIELD_IncludeJobMetrics, Boolean.class, GetMode.STRICT);
    }

    public JobExecutionQuery setIncludeJobMetrics(Boolean value, SetMode mode) {
        this.putDirect(FIELD_IncludeJobMetrics, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public JobExecutionQuery setIncludeJobMetrics(@Nonnull Boolean value) {
        this.putDirect(FIELD_IncludeJobMetrics, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery setIncludeJobMetrics(boolean value) {
        this.putDirect(FIELD_IncludeJobMetrics, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIncludeTaskMetrics() {
        return this.contains(FIELD_IncludeTaskMetrics);
    }

    public void removeIncludeTaskMetrics() {
        this.remove(FIELD_IncludeTaskMetrics);
    }

    public Boolean isIncludeTaskMetrics(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_IncludeTaskMetrics, Boolean.class, mode);
    }

    @Nullable
    public Boolean isIncludeTaskMetrics() {
        return (Boolean)this.obtainDirect(FIELD_IncludeTaskMetrics, Boolean.class, GetMode.STRICT);
    }

    public JobExecutionQuery setIncludeTaskMetrics(Boolean value, SetMode mode) {
        this.putDirect(FIELD_IncludeTaskMetrics, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public JobExecutionQuery setIncludeTaskMetrics(@Nonnull Boolean value) {
        this.putDirect(FIELD_IncludeTaskMetrics, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery setIncludeTaskMetrics(boolean value) {
        this.putDirect(FIELD_IncludeTaskMetrics, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIncludeTaskExecutions() {
        return this.contains(FIELD_IncludeTaskExecutions);
    }

    public void removeIncludeTaskExecutions() {
        this.remove(FIELD_IncludeTaskExecutions);
    }

    public Boolean isIncludeTaskExecutions(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_IncludeTaskExecutions, Boolean.class, mode);
    }

    @Nullable
    public Boolean isIncludeTaskExecutions() {
        return (Boolean)this.obtainDirect(FIELD_IncludeTaskExecutions, Boolean.class, GetMode.STRICT);
    }

    public JobExecutionQuery setIncludeTaskExecutions(Boolean value, SetMode mode) {
        this.putDirect(FIELD_IncludeTaskExecutions, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public JobExecutionQuery setIncludeTaskExecutions(@Nonnull Boolean value) {
        this.putDirect(FIELD_IncludeTaskExecutions, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery setIncludeTaskExecutions(boolean value) {
        this.putDirect(FIELD_IncludeTaskExecutions, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasIncludeJobsWithoutTasks() {
        return this.contains(FIELD_IncludeJobsWithoutTasks);
    }

    public void removeIncludeJobsWithoutTasks() {
        this.remove(FIELD_IncludeJobsWithoutTasks);
    }

    public Boolean isIncludeJobsWithoutTasks(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_IncludeJobsWithoutTasks, Boolean.class, mode);
    }

    @Nullable
    public Boolean isIncludeJobsWithoutTasks() {
        return (Boolean)this.obtainDirect(FIELD_IncludeJobsWithoutTasks, Boolean.class, GetMode.STRICT);
    }

    public JobExecutionQuery setIncludeJobsWithoutTasks(Boolean value, SetMode mode) {
        this.putDirect(FIELD_IncludeJobsWithoutTasks, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public JobExecutionQuery setIncludeJobsWithoutTasks(@Nonnull Boolean value) {
        this.putDirect(FIELD_IncludeJobsWithoutTasks, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery setIncludeJobsWithoutTasks(boolean value) {
        this.putDirect(FIELD_IncludeJobsWithoutTasks, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQuery clone() throws CloneNotSupportedException {
        return (JobExecutionQuery)super.clone();
    }

    public JobExecutionQuery copy() throws CloneNotSupportedException {
        return (JobExecutionQuery)super.copy();
    }

    public static final class Id
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema((String)"[\"string\",{\"type\":\"record\",\"name\":\"Table\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},{\"type\":\"enum\",\"name\":\"QueryListType\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Listing distinct jobs fetches the most recent execution info for each job name in the database. Listing recent jobs fetches the most recent job executions, regardless of job name.\",\"symbols\":[\"DISTINCT\",\"RECENT\"]}]");
        private static final DataSchema MEMBER_String = SCHEMA.getType("string");
        private static final DataSchema MEMBER_Table = SCHEMA.getType("org.apache.gobblin.rest.Table");
        private static final DataSchema MEMBER_QueryListType = SCHEMA.getType("org.apache.gobblin.rest.QueryListType");

        public Id() {
            super((Object)new DataMap(), SCHEMA);
        }

        public Id(Object data) {
            super(data, SCHEMA);
        }

        public static Id create(String value) {
            Id newUnion = new Id();
            newUnion.setString(value);
            return newUnion;
        }

        public boolean isString() {
            return this.memberIs("string");
        }

        public String getString() {
            return (String)this.obtainDirect(MEMBER_String, String.class, "string");
        }

        public void setString(String value) {
            this.selectDirect(MEMBER_String, String.class, String.class, "string", value);
        }

        public static Id create(Table value) {
            Id newUnion = new Id();
            newUnion.setTable(value);
            return newUnion;
        }

        public boolean isTable() {
            return this.memberIs("org.apache.gobblin.rest.Table");
        }

        public Table getTable() {
            return (Table)this.obtainWrapped(MEMBER_Table, Table.class, "org.apache.gobblin.rest.Table");
        }

        public void setTable(Table value) {
            this.selectWrapped(MEMBER_Table, Table.class, "org.apache.gobblin.rest.Table", (DataTemplate)value);
        }

        public static Id create(QueryListType value) {
            Id newUnion = new Id();
            newUnion.setQueryListType(value);
            return newUnion;
        }

        public boolean isQueryListType() {
            return this.memberIs("org.apache.gobblin.rest.QueryListType");
        }

        public QueryListType getQueryListType() {
            return (QueryListType)((Object)this.obtainDirect(MEMBER_QueryListType, QueryListType.class, "org.apache.gobblin.rest.QueryListType"));
        }

        public void setQueryListType(QueryListType value) {
            this.selectDirect(MEMBER_QueryListType, QueryListType.class, String.class, "org.apache.gobblin.rest.QueryListType", (Object)value);
        }

        public Id clone() throws CloneNotSupportedException {
            return (Id)super.clone();
        }

        public Id copy() throws CloneNotSupportedException {
            return (Id)super.copy();
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public PathSpec String() {
                return new PathSpec(this.getPathComponents(), "string");
            }

            public Table.Fields Table() {
                return new Table.Fields(this.getPathComponents(), "org.apache.gobblin.rest.Table");
            }

            public PathSpec QueryListType() {
                return new PathSpec(this.getPathComponents(), "org.apache.gobblin.rest.QueryListType");
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public Id.Fields id() {
            return new Id.Fields(this.getPathComponents(), "id");
        }

        public PathSpec idType() {
            return new PathSpec(this.getPathComponents(), "idType");
        }

        public TimeRange.Fields timeRange() {
            return new TimeRange.Fields(this.getPathComponents(), "timeRange");
        }

        public PathSpec limit() {
            return new PathSpec(this.getPathComponents(), "limit");
        }

        public PathSpec jobProperties() {
            return new PathSpec(this.getPathComponents(), "jobProperties");
        }

        public PathSpec taskProperties() {
            return new PathSpec(this.getPathComponents(), "taskProperties");
        }

        public PathSpec includeJobMetrics() {
            return new PathSpec(this.getPathComponents(), "includeJobMetrics");
        }

        public PathSpec includeTaskMetrics() {
            return new PathSpec(this.getPathComponents(), "includeTaskMetrics");
        }

        public PathSpec includeTaskExecutions() {
            return new PathSpec(this.getPathComponents(), "includeTaskExecutions");
        }

        public PathSpec includeJobsWithoutTasks() {
            return new PathSpec(this.getPathComponents(), "includeJobsWithoutTasks");
        }
    }
}

