/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerContext;
import kafka.controller.RequestSendThread;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.server.KafkaConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001\u001d\u0011\u0001dQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%IAF\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"AA\u0004\u0001B\u0001B\u0003%q#\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\r\r|gNZ5h!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0004tKJ4XM]\u0005\u0003I\u0005\u00121bS1gW\u0006\u001cuN\u001c4jO\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001K\u0015+!\tA\u0002\u0001C\u0003\u0016K\u0001\u0007q\u0003C\u0003\u001fK\u0001\u0007q\u0004C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u001f\t\u0014xn[3s'R\fG/Z%oM>,\u0012A\f\t\u0005_Q2\u0014(D\u00011\u0015\t\t$'A\u0004nkR\f'\r\\3\u000b\u0005MR\u0011AC2pY2,7\r^5p]&\u0011Q\u0007\r\u0002\b\u0011\u0006\u001c\b.T1q!\tIq'\u0003\u00029\u0015\t\u0019\u0011J\u001c;\u0011\u0005aQ\u0014BA\u001e\u0003\u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\t\ru\u0002\u0001\u0015!\u0003/\u0003A\u0011'o\\6feN#\u0018\r^3J]\u001a|\u0007\u0005C\u0004@\u0001\t\u0007I\u0011\u0002!\u0002\u0015\t\u0014xn[3s\u0019>\u001c7.F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u00142kK\u000e$\bB\u0002&\u0001A\u0003%\u0011)A\u0006ce>\\WM\u001d'pG.\u0004\u0003\"\u0002'\u0001\t\u0003i\u0015aB:uCJ$X\u000f\u001d\u000b\u0002\u001dB\u0011\u0011bT\u0005\u0003!*\u0011A!\u00168ji\")!\u000b\u0001C\u0001\u001b\u0006A1\u000f[;uI><h\u000eC\u0003U\u0001\u0011\u0005Q+A\u0006tK:$'+Z9vKN$H\u0003\u0002(W1\u0002DQaV*A\u0002Y\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u00063N\u0003\rAW\u0001\be\u0016\fX/Z:u!\tYf,D\u0001]\u0015\tiF!A\u0002ba&L!a\u0018/\u0003#I+\u0017/^3ti>\u0013(+Z:q_:\u001cX\rC\u0004b'B\u0005\t\u0019\u00012\u0002\u0011\r\fG\u000e\u001c2bG.\u0004B!C2[\u001d&\u0011AM\u0003\u0002\n\rVt7\r^5p]FBQA\u001a\u0001\u0005\u0002\u001d\f\u0011\"\u00193e\u0005J|7.\u001a:\u0015\u00059C\u0007\"B5f\u0001\u0004Q\u0017A\u00022s_.,'\u000f\u0005\u0002l]6\tAN\u0003\u0002n\t\u000591\r\\;ti\u0016\u0014\u0018BA8m\u0005\u0019\u0011%o\\6fe\")\u0011\u000f\u0001C\u0001e\u0006a!/Z7pm\u0016\u0014%o\\6feR\u0011aj\u001d\u0005\u0006/B\u0004\rA\u000e\u0005\u0006k\u0002!IA^\u0001\rC\u0012$g*Z<Ce>\\WM\u001d\u000b\u0003\u001d^DQ!\u001b;A\u0002)DQ!\u001f\u0001\u0005\ni\fAC]3n_Z,W\t_5ti&twM\u0011:pW\u0016\u0014HC\u0001(|\u0011\u00159\u0006\u00101\u00017\u0011\u0015i\b\u0001\"\u0003\u007f\u0003Y\u0019H/\u0019:u%\u0016\fX/Z:u'\u0016tG\r\u00165sK\u0006$GC\u0001(\u0000\u0011\u00159F\u00101\u00017\u0011%\t\u0019\u0001AI\u0001\n\u0003\t)!A\u000btK:$'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d!f\u00012\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016)\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ControllerChannelManager
implements Logging {
    private final ControllerContext controllerContext;
    public final KafkaConfig kafka$controller$ControllerChannelManager$$config;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ControllerChannelManager controllerChannelManager = this;
        synchronized (controllerChannelManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public void startup() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ControllerChannelManager $outer;

                public final void apply(Tuple2<Object, ControllerBrokerStateInfo> brokerState) {
                    this.$outer.kafka$controller$ControllerChannelManager$$startRequestSendThread(brokerState._1$mcI$sp());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ControllerChannelManager $outer;

                public final void apply(Tuple2<Object, ControllerBrokerStateInfo> brokerState) {
                    this.$outer.kafka$controller$ControllerChannelManager$$removeExistingBroker(brokerState._1$mcI$sp());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public void sendRequest(int brokerId, RequestOrResponse request, Function1<RequestOrResponse, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option option;
            block7: {
                block6: {
                    block5: {
                        Option stateInfoOpt;
                        option = stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        ControllerBrokerStateInfo stateInfo = (ControllerBrokerStateInfo)some.x();
                        stateInfo.messageQueue().put((Tuple2<RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>>)new Tuple2((Object)request, callback));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option)) break block7;
                    this.warn((Function0<String>)new Serializable(this, brokerId, request){
                        public static final long serialVersionUID = 0L;
                        private final int brokerId$1;
                        private final RequestOrResponse request$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Not sending request %s to broker %d, since it is offline.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1, BoxesRunTime.boxToInteger((int)this.brokerId$1)}));
                        }
                        {
                            this.brokerId$1 = brokerId$1;
                            this.request$1 = request$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public Function1<RequestOrResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.kafka$controller$ControllerChannelManager$$addNewBroker(broker);
                this.kafka$controller$ControllerChannelManager$$startRequestSendThread(broker.id());
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.kafka$controller$ControllerChannelManager$$removeExistingBroker(brokerId);
            return;
        }
    }

    public void kafka$controller$ControllerChannelManager$$addNewBroker(Broker broker) {
        LinkedBlockingQueue<Tuple2<RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>>> messageQueue = new LinkedBlockingQueue<Tuple2<RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>>>(this.kafka$controller$ControllerChannelManager$$config.controllerMessageQueueSize());
        this.debug((Function0<String>)new Serializable(this, broker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerChannelManager $outer;
            private final Broker broker$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Controller %d trying to connect to broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ControllerChannelManager$$config.brokerId()), BoxesRunTime.boxToInteger((int)this.broker$1.id())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker$1 = broker$1;
            }
        });
        BlockingChannel channel = new BlockingChannel(broker.host(), broker.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), this.kafka$controller$ControllerChannelManager$$config.controllerSocketTimeoutMs());
        RequestSendThread requestThread = new RequestSendThread(this.kafka$controller$ControllerChannelManager$$config.brokerId(), this.controllerContext(), broker, messageQueue, channel);
        requestThread.setDaemon(false);
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo(channel, broker, messageQueue, requestThread));
    }

    public void kafka$controller$ControllerChannelManager$$removeExistingBroker(int brokerId) {
        try {
            ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).channel().disconnect();
            ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).messageQueue().clear();
            ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread().shutdown();
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerId));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while removing broker by the controller";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public void kafka$controller$ControllerChannelManager$$startRequestSendThread(int brokerId) {
        RequestSendThread requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
        Thread.State state = requestThread.getState();
        Thread.State state2 = Thread.State.NEW;
        if (!(state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null)) {
            requestThread.start();
        }
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config) {
        this.controllerContext = controllerContext;
        this.kafka$controller$ControllerChannelManager$$config = config;
        Logging$class.$init$(this);
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Channel manager on controller ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        controllerContext.liveBrokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerChannelManager $outer;

            public final void apply(Broker x$1) {
                this.$outer.kafka$controller$ControllerChannelManager$$addNewBroker(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

