/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.mapreduce;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.JobLauncher;
import org.apache.gobblin.runtime.app.ApplicationException;
import org.apache.gobblin.runtime.app.ApplicationLauncher;
import org.apache.gobblin.runtime.app.ServiceBasedAppLauncher;
import org.apache.gobblin.runtime.cli.CliOptions;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.runtime.mapreduce.MRJobLauncher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CliMRJobLauncher
extends Configured
implements ApplicationLauncher,
JobLauncher,
Tool {
    private final Closer closer = Closer.create();
    private final ApplicationLauncher applicationLauncher;
    private final MRJobLauncher mrJobLauncher;

    public CliMRJobLauncher(Configuration conf, Properties jobProperties) throws Exception {
        this.setConf(conf);
        this.applicationLauncher = (ApplicationLauncher)this.closer.register((Closeable)new ServiceBasedAppLauncher(jobProperties, jobProperties.getProperty("app.name", "CliMRJob-" + UUID.randomUUID())));
        this.mrJobLauncher = (MRJobLauncher)this.closer.register((Closeable)new MRJobLauncher(jobProperties, this.getConf(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        try {
            this.start();
            this.launchJob(null);
        }
        finally {
            try {
                this.stop();
            }
            finally {
                this.close();
            }
        }
        return 0;
    }

    @Override
    public void start() throws ApplicationException {
        this.applicationLauncher.start();
    }

    @Override
    public void stop() throws ApplicationException {
        this.applicationLauncher.stop();
    }

    @Override
    public void launchJob(@Nullable JobListener jobListener) throws JobException {
        this.mrJobLauncher.launchJob(jobListener);
    }

    @Override
    public void cancelJob(@Nullable JobListener jobListener) throws JobException {
        this.mrJobLauncher.cancelJob(jobListener);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] genericCmdLineOpts = new GenericOptionsParser(conf, args).getCommandLine().getArgs();
        Properties jobProperties = CliOptions.parseArgs(CliMRJobLauncher.class, genericCmdLineOpts);
        System.exit(ToolRunner.run((Tool)new CliMRJobLauncher(conf, jobProperties), (String[])args));
    }
}

