/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.data.ByteString;
import com.linkedin.r2.filter.compression.streaming.BufferedReaderInputStream;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.apache.commons.io.IOUtils;

abstract class StreamingInflater
extends BufferedReaderInputStream
implements Writer {
    private static final int BUF_SIZE = 8192;
    private final Executor _executor;
    private WriteHandle _wh;
    private InputStream _in;
    private final EntityStream _underlying;

    public StreamingInflater(EntityStream underlying, Executor executor) {
        this._executor = executor;
        this._underlying = underlying;
    }

    public void onInit(WriteHandle wh) {
        this._wh = wh;
        this._underlying.setReader((Reader)this);
    }

    public void onWritePossible() {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (StreamingInflater.this._in == null) {
                        StreamingInflater.this._in = StreamingInflater.this.createInputStream(StreamingInflater.this);
                    }
                    byte[] bytes = new byte[8192];
                    while (StreamingInflater.this._wh.remaining() > 0) {
                        int readlen = StreamingInflater.this._in.read(bytes);
                        if (readlen == -1) {
                            StreamingInflater.this._wh.done();
                            return;
                        }
                        StreamingInflater.this._wh.write(ByteString.copy((byte[])bytes, (int)0, (int)readlen));
                    }
                }
                catch (IOException ex) {
                    StreamingInflater.this._wh.error((Throwable)ex);
                }
            }
        });
    }

    public void onAbort(Throwable e) {
        IOUtils.closeQuietly((InputStream)this._in);
    }

    protected abstract InputStream createInputStream(InputStream var1) throws IOException;
}

