/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract class StreamingDeflater
implements Reader,
Writer {
    private ReadHandle _rh;
    private WriteHandle _wh;
    private OutputStream _out;
    private BufferedWriterOutputStream _writerOutputStream;
    private volatile boolean _readCancelled = false;
    private final EntityStream _underlying;

    public StreamingDeflater(EntityStream underlying) {
        this._underlying = underlying;
    }

    public void onInit(ReadHandle rh) {
        this._rh = rh;
    }

    public void onDataAvailable(ByteString data) {
        if (!this._readCancelled) {
            try {
                data.write(this._out);
                if (this._writerOutputStream.needMore()) {
                    this._rh.request(1);
                }
            }
            catch (IOException e) {
                this._wh.error((Throwable)e);
                this.cancel();
            }
        }
    }

    public void onDone() {
        try {
            this._out.close();
        }
        catch (IOException e) {
            this._wh.error((Throwable)e);
        }
    }

    public void onError(Throwable e) {
        this._wh.error(e);
    }

    public void onInit(WriteHandle wh) {
        try {
            this._wh = wh;
            this._writerOutputStream = new BufferedWriterOutputStream();
            this._out = this.createOutputStream(this._writerOutputStream);
            this._underlying.setReader((Reader)this);
        }
        catch (IOException e) {
            this._wh.error((Throwable)e);
            this.cancel();
        }
    }

    public void onWritePossible() {
        this._writerOutputStream.writeIfPossible();
    }

    public void onAbort(Throwable e) {
        this.cancel();
    }

    private void cancel() {
        this._rh.cancel();
        this._readCancelled = true;
    }

    protected abstract OutputStream createOutputStream(OutputStream var1) throws IOException;

    private class BufferedWriterOutputStream
    extends OutputStream {
        private static final int BUF_SIZE = 8192;
        private final Queue<ByteString> _data = new ConcurrentLinkedQueue<ByteString>();
        private final byte[] _buffer = new byte[8192];
        private int _writeIndex = 0;
        private boolean _done = false;

        private BufferedWriterOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this._buffer[this._writeIndex++] = (byte)b;
            if (this._writeIndex == 8192) {
                this._data.add(ByteString.copy((byte[])this._buffer));
                this._writeIndex = 0;
                this.writeIfPossible();
            }
        }

        @Override
        public void close() throws IOException {
            if (this._writeIndex > 0) {
                this._data.add(ByteString.copy((byte[])this._buffer, (int)0, (int)this._writeIndex));
            }
            this._done = true;
            this.writeIfPossible();
        }

        public synchronized void writeIfPossible() {
            while (StreamingDeflater.this._wh.remaining() > 0) {
                if (this._data.isEmpty()) {
                    if (this._done) {
                        StreamingDeflater.this._wh.done();
                    } else {
                        StreamingDeflater.this._rh.request(1);
                    }
                    return;
                }
                StreamingDeflater.this._wh.write(this._data.poll());
            }
        }

        public boolean needMore() {
            return StreamingDeflater.this._wh.remaining() > 0 && this._data.isEmpty();
        }
    }
}

