/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.ServerCompressionHelper;
import com.linkedin.r2.filter.compression.streaming.AcceptEncoding;
import com.linkedin.r2.filter.compression.streaming.PartialReader;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import com.linkedin.r2.filter.compression.streaming.StreamingCompressor;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.MessageHeaders;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.CompositeWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStreamCompressionFilter
implements StreamFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStreamCompressionFilter.class);
    private final Set<StreamEncodingType> _supportedEncoding;
    private final Executor _executor;
    private final ServerCompressionHelper _serverCompressionHelper;

    public ServerStreamCompressionFilter(String acceptedFilters, Executor executor) {
        this(acceptedFilters, executor, Integer.MAX_VALUE);
    }

    public ServerStreamCompressionFilter(String acceptedFilters, Executor executor, int compressThreshold) {
        this(AcceptEncoding.parseAcceptEncoding(acceptedFilters), executor, compressThreshold);
    }

    public ServerStreamCompressionFilter(StreamEncodingType[] supportedEncoding, Executor executor, int compressThreshold) {
        this._supportedEncoding = new HashSet<StreamEncodingType>(Arrays.asList(supportedEncoding));
        this._supportedEncoding.add(StreamEncodingType.IDENTITY);
        this._supportedEncoding.add(StreamEncodingType.ANY);
        this._executor = executor;
        this._serverCompressionHelper = new ServerCompressionHelper(compressThreshold);
    }

    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        try {
            String responseCompression;
            String requestContentEncoding = req.getHeader("Content-Encoding");
            if (requestContentEncoding != null) {
                StreamEncodingType encoding = StreamEncodingType.get(requestContentEncoding.trim().toLowerCase());
                if (encoding == null || encoding == StreamEncodingType.ANY) {
                    throw new CompressionException("Unsupported encoding referenced: " + requestContentEncoding);
                }
                StreamingCompressor compressor = encoding.getCompressor(this._executor);
                if (compressor == null) {
                    throw new CompressionException("Unknown encoding type: " + (Object)((Object)encoding));
                }
                EntityStream uncompressedStream = compressor.inflate(req.getEntityStream());
                Map<String, String> headers = this.stripHeaders(req.getHeaders(), "Content-Encoding", "Content-Length");
                req = ((StreamRequestBuilder)req.builder().setHeaders(headers)).build(uncompressedStream);
            }
            if ((responseCompression = req.getHeader("Accept-Encoding")) == null) {
                responseCompression = StreamEncodingType.IDENTITY.getHttpName();
            }
            if (!responseCompression.equalsIgnoreCase(StreamEncodingType.IDENTITY.getHttpName())) {
                requestContext.putLocalAttr("X-Response-Compression-Threshold", (Object)this._serverCompressionHelper.getResponseCompressionThreshold((MessageHeaders)req));
            }
            requestContext.putLocalAttr("Accept-Encoding", (Object)responseCompression);
            nextFilter.onRequest((Request)req, requestContext, wireAttrs);
        }
        catch (CompressionException ex) {
            LOG.error(ex.getMessage(), ex.getCause());
            StreamResponse streamResponse = ((StreamResponseBuilder)new StreamResponseBuilder().setStatus(415)).build(EntityStreams.emptyStream());
            nextFilter.onError((Throwable)new StreamException(streamResponse, (Throwable)ex), requestContext, wireAttrs);
        }
    }

    public void onStreamResponse(final StreamResponse res, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
        StreamResponse response = res;
        try {
            String responseCompression = (String)requestContext.getLocalAttr("Accept-Encoding");
            if (responseCompression == null) {
                throw new CompressionException("Accept-Encoding not in local attribute.");
            }
            List<AcceptEncoding> parsedEncodings = AcceptEncoding.parseAcceptEncodingHeader(responseCompression, this._supportedEncoding);
            StreamEncodingType selectedEncoding = AcceptEncoding.chooseBest(parsedEncodings);
            if (selectedEncoding == null) {
                response = ((StreamResponseBuilder)new StreamResponseBuilder().setStatus(406)).build(EntityStreams.emptyStream());
            } else if (selectedEncoding != StreamEncodingType.IDENTITY) {
                int threshold = (Integer)requestContext.getLocalAttr("X-Response-Compression-Threshold");
                final StreamingCompressor compressor = selectedEncoding.getCompressor(this._executor);
                PartialReader reader = new PartialReader(threshold, new Callback<EntityStream[]>(){

                    public void onError(Throwable ex) {
                        nextFilter.onError(ex, requestContext, wireAttrs);
                    }

                    public void onSuccess(EntityStream[] results) {
                        if (results.length == 1) {
                            StreamResponse response = res.builder().build(results[0]);
                            nextFilter.onResponse((Response)response, requestContext, wireAttrs);
                        } else {
                            EntityStream compressedStream = compressor.deflate(EntityStreams.newEntityStream((Writer)new CompositeWriter(results)));
                            StreamResponseBuilder builder = res.builder();
                            if (builder.getHeader("Content-Length") != null) {
                                Map headers = ServerStreamCompressionFilter.this.stripHeaders(builder.getHeaders(), new String[]{"Content-Length"});
                                builder.setHeaders(headers);
                            }
                            StreamResponse response = ((StreamResponseBuilder)builder.addHeaderValue("Content-Encoding", compressor.getContentEncodingName())).build(compressedStream);
                            nextFilter.onResponse((Response)response, requestContext, wireAttrs);
                        }
                    }
                });
                res.getEntityStream().setReader((Reader)reader);
                return;
            }
        }
        catch (CompressionException e) {
            LOG.error(e.getMessage(), e.getCause());
        }
        nextFilter.onResponse((Response)response, requestContext, wireAttrs);
    }

    public void onStreamError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        nextFilter.onError(ex, requestContext, wireAttrs);
    }

    private Map<String, String> stripHeaders(Map<String, String> headerMap, String ... headers) {
        TreeMap<String, String> newMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        newMap.putAll(headerMap);
        for (String header : headers) {
            newMap.remove(header);
        }
        return newMap;
    }
}

