/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.message.MessageHeaders;

public final class ServerCompressionHelper {
    private final CompressionConfig _defaultResponseCompressionConfig;

    public ServerCompressionHelper(int defaultThreshold) {
        this(new CompressionConfig(defaultThreshold));
    }

    public ServerCompressionHelper(CompressionConfig defaultResponseCompressionConfig) {
        this._defaultResponseCompressionConfig = defaultResponseCompressionConfig;
    }

    public int getResponseCompressionThreshold(MessageHeaders message) throws CompressionException {
        String responseCompressionThreshold = message.getHeader("X-Response-Compression-Threshold");
        if (responseCompressionThreshold != null) {
            try {
                return Integer.parseInt(responseCompressionThreshold);
            }
            catch (NumberFormatException e) {
                throw new CompressionException("Invalid compression threshold: " + responseCompressionThreshold);
            }
        }
        return this._defaultResponseCompressionConfig.getCompressionThreshold();
    }
}

