/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.io.IOUtils;

public class DeflateCompressor
implements Compressor {
    private static final String HTTP_NAME = "deflate";

    @Override
    public String getContentEncodingName() {
        return HTTP_NAME;
    }

    @Override
    public byte[] inflate(InputStream data) throws CompressionException {
        byte[] input;
        try {
            input = IOUtils.toByteArray((InputStream)data);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: Bad input stream", e);
        }
        Inflater zlib = new Inflater();
        zlib.setInput(input);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] temp = new byte[4096];
        while (!zlib.finished()) {
            int bytesRead;
            try {
                bytesRead = zlib.inflate(temp);
            }
            catch (DataFormatException e) {
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
            }
            if (bytesRead == 0) {
                if (zlib.needsInput()) break;
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName());
            }
            if (bytesRead <= 0) continue;
            output.write(temp, 0, bytesRead);
        }
        zlib.end();
        return output.toByteArray();
    }

    @Override
    public byte[] deflate(InputStream data) throws CompressionException {
        byte[] input;
        try {
            input = IOUtils.toByteArray((InputStream)data);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: Bad input stream", e);
        }
        Deflater zlib = new Deflater();
        zlib.setInput(input);
        zlib.finish();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] temp = new byte[4096];
        while (!zlib.finished()) {
            int bytesRead = zlib.deflate(temp);
            if (bytesRead == 0) {
                if (zlib.needsInput()) break;
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName());
            }
            output.write(temp, 0, bytesRead);
        }
        zlib.end();
        return output.toByteArray();
    }
}

