/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.CompressionOption;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.compression.AcceptEncoding;
import com.linkedin.r2.filter.compression.ClientCompressionHelper;
import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCompressionFilter
implements RestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCompressionFilter.class);
    private final EncodingType _requestContentEncoding;
    private final CompressionConfig _responseCompressionConfig;
    private final String _acceptEncodingHeader;
    private final ClientCompressionHelper _helper;

    public ClientCompressionFilter(EncodingType requestContentEncoding, CompressionConfig requestCompressionConfig, EncodingType[] acceptedEncodings, CompressionConfig responseCompressionConfig, List<String> responseCompressionOperations) {
        if (requestContentEncoding == null) {
            throw new IllegalArgumentException("Request compression encoding must be valid non-null, use \"identity\"/EncodingType.IDENTITY for no compression.");
        }
        if (requestContentEncoding.equals((Object)EncodingType.ANY)) {
            throw new IllegalArgumentException("ANY may not be used as request encoding type: " + requestContentEncoding.getHttpName());
        }
        if (acceptedEncodings == null) {
            acceptedEncodings = new EncodingType[]{};
        }
        for (EncodingType type : acceptedEncodings) {
            if (type != null) continue;
            throw new IllegalArgumentException("Cannot use null encoding as an accept encoding value.");
        }
        if (requestCompressionConfig == null) {
            throw new IllegalArgumentException("Compression config should not be null.");
        }
        this._requestContentEncoding = requestContentEncoding;
        this._acceptEncodingHeader = ClientCompressionFilter.buildAcceptEncodingHeader(acceptedEncodings);
        this._responseCompressionConfig = responseCompressionConfig;
        this._helper = new ClientCompressionHelper(requestCompressionConfig, responseCompressionOperations);
    }

    public ClientCompressionFilter(String requestContentEncoding, CompressionConfig requestCompressionConfig, String acceptedEncodings, CompressionConfig responseCompressionConfig, List<String> responseCompressionOperations) {
        this(requestContentEncoding.trim().isEmpty() ? EncodingType.IDENTITY : EncodingType.get(requestContentEncoding.trim().toLowerCase()), requestCompressionConfig, AcceptEncoding.parseAcceptEncoding(acceptedEncodings), responseCompressionConfig, responseCompressionOperations);
    }

    static String buildAcceptEncodingHeader(EncodingType[] acceptedEncodings) {
        float delta = 1.0f / (float)(acceptedEncodings.length + 1);
        float currentQuality = 1.0f;
        StringBuilder acceptEncodingValue = new StringBuilder();
        for (int i = 0; i < acceptedEncodings.length; ++i) {
            EncodingType t = acceptedEncodings[i];
            if (i > 0) {
                acceptEncodingValue.append(",");
            }
            acceptEncodingValue.append(t.getHttpName());
            acceptEncodingValue.append(";");
            acceptEncodingValue.append("q=");
            acceptEncodingValue.append(String.format("%.2f", Float.valueOf(currentQuality)));
            currentQuality -= delta;
        }
        return acceptEncodingValue.toString();
    }

    public RestRequest addResponseCompressionHeaders(CompressionOption responseCompressionOverride, RestRequest req) {
        RestRequestBuilder builder = req.builder();
        if (responseCompressionOverride == null) {
            builder.addHeaderValue("Accept-Encoding", this._acceptEncodingHeader);
            if (this._responseCompressionConfig != null) {
                builder.addHeaderValue("X-Response-Compression-Threshold", Integer.toString(this._responseCompressionConfig.getCompressionThreshold()));
            }
        } else if (responseCompressionOverride == CompressionOption.FORCE_ON) {
            ((RestRequestBuilder)builder.addHeaderValue("Accept-Encoding", this._acceptEncodingHeader)).addHeaderValue("X-Response-Compression-Threshold", Integer.toString(0));
        }
        return builder.build();
    }

    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        try {
            Compressor compressor;
            byte[] compressed;
            if (this._requestContentEncoding.hasCompressor() && this._helper.shouldCompressRequest(req.getEntity().length(), (CompressionOption)requestContext.getLocalAttr("REQUEST_COMPRESSION_OVERRIDE")) && (compressed = (compressor = this._requestContentEncoding.getCompressor()).deflate(req.getEntity().asInputStream())).length < req.getEntity().length()) {
                req = ((RestRequestBuilder)req.builder().setEntity(compressed).setHeader("Content-Encoding", compressor.getContentEncodingName())).build();
            }
            String operation = (String)requestContext.getLocalAttr("OPERATION");
            if (!this._acceptEncodingHeader.isEmpty() && this._helper.shouldCompressResponseForOperation(operation)) {
                CompressionOption responseCompressionOverride = (CompressionOption)requestContext.getLocalAttr("RESPONSE_COMPRESSION_OVERRIDE");
                req = this.addResponseCompressionHeaders(responseCompressionOverride, req);
            }
        }
        catch (CompressionException e) {
            LOG.error(e.getMessage(), e.getCause());
        }
        nextFilter.onRequest((Request)req, requestContext, wireAttrs);
    }

    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        block6: {
            Boolean decompressionOff = (Boolean)requestContext.getLocalAttr("RESPONSE_DECOMPRESSION_OFF");
            if (decompressionOff == null || !decompressionOff.booleanValue()) {
                try {
                    String compressionHeader = res.getHeader("Content-Encoding");
                    if (compressionHeader == null || res.getEntity().length() <= 0) break block6;
                    EncodingType encoding = null;
                    try {
                        encoding = EncodingType.get(compressionHeader.trim().toLowerCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new CompressionException("Server returned unrecognized content encoding: " + compressionHeader);
                    }
                    if (!encoding.hasCompressor()) {
                        throw new CompressionException("Server returned unrecognized content encoding: " + compressionHeader);
                    }
                    byte[] inflated = encoding.getCompressor().inflate(res.getEntity().asInputStream());
                    HashMap<String, String> headers = new HashMap<String, String>(res.getHeaders());
                    headers.remove("Content-Encoding");
                    headers.put("Content-Length", Integer.toString(inflated.length));
                    res = ((RestResponseBuilder)res.builder().setEntity(inflated).setHeaders(headers)).build();
                }
                catch (CompressionException e) {
                    nextFilter.onError((Throwable)e, requestContext, wireAttrs);
                    return;
                }
            }
        }
        nextFilter.onResponse((Response)res, requestContext, wireAttrs);
    }

    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        nextFilter.onError(ex, requestContext, wireAttrs);
    }
}

