/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.BaseConnector;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.Observer;
import com.linkedin.r2.transport.common.MessageType;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.common.HttpBridge;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HttpDispatcher {
    private final TransportDispatcher _dispatcher;

    public HttpDispatcher(TransportDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    public void handleRequest(RestRequest req, TransportCallback<RestResponse> callback) {
        this.handleRequest(req, new RequestContext(), callback);
    }

    public void handleRequest(RestRequest req, RequestContext context, TransportCallback<RestResponse> callback) {
        HashMap<String, String> headers = new HashMap<String, String>(req.getHeaders());
        Map<String, String> wireAttrs = WireAttributeHelper.removeWireAttributes(headers);
        try {
            MessageType.Type msgType = MessageType.getMessageType(wireAttrs, MessageType.Type.REST);
            switch (msgType) {
                default: 
            }
            this._dispatcher.handleRestRequest(HttpBridge.toRestRequest(req, headers), wireAttrs, context, HttpBridge.httpToRestCallback(callback));
        }
        catch (Exception e) {
            callback.onResponse(TransportResponseImpl.error(e, Collections.emptyMap()));
        }
    }

    public void handleRequest(StreamRequest req, TransportCallback<StreamResponse> callback) {
        this.handleRequest(req, new RequestContext(), callback);
    }

    public void handleRequest(StreamRequest req, RequestContext context, final TransportCallback<StreamResponse> callback) {
        HashMap<String, String> headers = new HashMap<String, String>(req.getHeaders());
        Map<String, String> wireAttrs = WireAttributeHelper.removeWireAttributes(headers);
        final BaseConnector connector = new BaseConnector();
        try {
            MessageType.Type msgType = MessageType.getMessageType(wireAttrs, MessageType.Type.REST);
            switch (msgType) {
                default: 
            }
            req.getEntityStream().setReader(connector);
            StreamRequest newReq = req.builder().build(EntityStreams.newEntityStream(connector));
            TransportCallback<StreamResponse> decorateCallback = new TransportCallback<StreamResponse>(){

                @Override
                public void onResponse(TransportResponse<StreamResponse> response) {
                    if (response.hasError()) {
                        connector.cancel();
                    } else {
                        Observer observer = new Observer(){

                            @Override
                            public void onDataAvailable(ByteString data) {
                            }

                            @Override
                            public void onDone() {
                                connector.cancel();
                            }

                            @Override
                            public void onError(Throwable e) {
                                connector.cancel();
                            }
                        };
                        response.getResponse().getEntityStream().addObserver(observer);
                    }
                    callback.onResponse(response);
                }
            };
            this._dispatcher.handleStreamRequest(HttpBridge.toStreamRequest(newReq, headers), wireAttrs, context, HttpBridge.httpToStreamCallback(decorateCallback));
        }
        catch (Exception e) {
            connector.cancel();
            callback.onResponse(TransportResponseImpl.error(e, Collections.emptyMap()));
        }
    }
}

