/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.ServletHelper;
import com.linkedin.r2.transport.http.server.SyncIOHandler;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractR2StreamServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private final long _ioHandlerTimeout;

    protected abstract HttpDispatcher getDispatcher();

    public AbstractR2StreamServlet(long ioHandlerTimeout) {
        this._ioHandlerTimeout = ioHandlerTimeout;
    }

    protected void service(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        StreamRequest streamRequest;
        final SyncIOHandler ioHandler = new SyncIOHandler(req.getInputStream(), resp.getOutputStream(), 2, this._ioHandlerTimeout);
        RequestContext requestContext = ServletHelper.readRequestContext(req);
        try {
            streamRequest = ServletHelper.readFromServletRequest(req, ioHandler);
        }
        catch (URISyntaxException e) {
            ServletHelper.writeToServletError(resp, RestStatus.BAD_REQUEST, e.toString());
            return;
        }
        TransportCallback<StreamResponse> callback = new TransportCallback<StreamResponse>(){

            @Override
            public void onResponse(TransportResponse<StreamResponse> response) {
                StreamResponse streamResponse = ServletHelper.writeResponseHeadersToServletResponse(response, resp);
                streamResponse.getEntityStream().setReader(ioHandler);
            }
        };
        this.getDispatcher().handleRequest(streamRequest, requestContext, callback);
        ioHandler.loop();
    }
}

