/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.http.server.AsyncEventIOHandler;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.ServletHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncR2StreamServlet
extends HttpServlet {
    private static final String ASYNC_IOEXCEPTION = "AsyncIOException";
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractAsyncR2StreamServlet.class.getName());
    private static final int MAX_BUFFERED_CHUNKS = 3;
    private final long _timeout;

    protected abstract HttpDispatcher getDispatcher();

    public AbstractAsyncR2StreamServlet(long timeout) {
        this._timeout = timeout;
    }

    public void service(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        StreamRequest streamRequest;
        final AsyncContext ctx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ctx.setTimeout(this._timeout);
        final WrappedAsyncContext wrappedCtx = new WrappedAsyncContext(ctx);
        final AsyncEventIOHandler ioHandler = new AsyncEventIOHandler(req.getInputStream(), resp.getOutputStream(), wrappedCtx, 3);
        final RequestContext requestContext = ServletHelper.readRequestContext(req);
        try {
            streamRequest = ServletHelper.readFromServletRequest(req, ioHandler);
        }
        catch (URISyntaxException e) {
            ServletHelper.writeToServletError(resp, RestStatus.BAD_REQUEST, e.toString());
            wrappedCtx.complete();
            return;
        }
        final AtomicBoolean startedResponding = new AtomicBoolean(false);
        ctx.addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
                LOG.error("Server timeout for request: " + AbstractAsyncR2StreamServlet.this.formatURI(req.getRequestURI()));
                if (startedResponding.compareAndSet(false, true)) {
                    LOG.info("Returning server timeout response");
                    ServletHelper.writeToServletError(resp, RestStatus.INTERNAL_SERVER_ERROR, "Server timeout");
                } else {
                    req.setAttribute(AbstractAsyncR2StreamServlet.ASYNC_IOEXCEPTION, (Object)new ServletException("Server timeout"));
                }
                ioHandler.exitLoop();
                wrappedCtx.complete();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
                LOG.error("Server error for request: " + AbstractAsyncR2StreamServlet.this.formatURI(req.getRequestURI()));
                if (startedResponding.compareAndSet(false, true)) {
                    LOG.info("Returning server error response");
                    ServletHelper.writeToServletError(resp, RestStatus.INTERNAL_SERVER_ERROR, "Server error");
                } else {
                    req.setAttribute(AbstractAsyncR2StreamServlet.ASYNC_IOEXCEPTION, (Object)new ServletException("Server error"));
                }
                ioHandler.exitLoop();
                wrappedCtx.complete();
            }

            public void onComplete(AsyncEvent event) throws IOException {
                Object exception = req.getAttribute(AbstractAsyncR2StreamServlet.ASYNC_IOEXCEPTION);
                if (exception != null) {
                    throw new IOException((Throwable)exception);
                }
            }
        });
        final TransportCallback<StreamResponse> callback = new TransportCallback<StreamResponse>(){

            @Override
            public void onResponse(final TransportResponse<StreamResponse> response) {
                if (startedResponding.compareAndSet(false, true)) {
                    ctx.start(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StreamResponse streamResponse = ServletHelper.writeResponseHeadersToServletResponse(response, resp);
                                streamResponse.getEntityStream().setReader(ioHandler);
                                ioHandler.loop();
                            }
                            catch (Exception e) {
                                req.setAttribute(AbstractAsyncR2StreamServlet.ASYNC_IOEXCEPTION, (Object)e);
                                wrappedCtx.complete();
                            }
                        }
                    });
                } else {
                    LOG.error("Dropped a response; this is mostly like because that AsyncContext timeout or error had already happened");
                }
            }
        };
        ctx.start(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractAsyncR2StreamServlet.this.getDispatcher().handleRequest(streamRequest, requestContext, callback);
                    ioHandler.loop();
                }
                catch (Exception e) {
                    req.setAttribute(AbstractAsyncR2StreamServlet.ASYNC_IOEXCEPTION, (Object)e);
                    wrappedCtx.complete();
                }
            }
        });
    }

    public long getTimeout() {
        return this._timeout;
    }

    private String formatURI(String uriText) {
        int queryStringIndex = uriText.lastIndexOf(63);
        return queryStringIndex >= 0 ? uriText.substring(0, queryStringIndex) : uriText;
    }

    static class WrappedAsyncContext {
        private final AtomicBoolean _completed = new AtomicBoolean(false);
        private final AsyncContext _ctx;

        WrappedAsyncContext(AsyncContext ctx) {
            this._ctx = ctx;
        }

        void complete() {
            if (this._completed.compareAndSet(false, true)) {
                this._ctx.complete();
            }
        }
    }
}

