/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.http.server.AbstractR2Servlet;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractAsyncR2Servlet
extends AbstractR2Servlet {
    private static final String TRANSPORT_CALLBACK_IOEXCEPTION = "TransportCallbackIOException";

    public AbstractAsyncR2Servlet(long timeout) {
        super(timeout);
    }

    @Override
    public void service(final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RestRequest restRequest;
        RequestContext requestContext = this.readRequestContext(req);
        try {
            restRequest = this.readFromServletRequest(req);
        }
        catch (URISyntaxException e) {
            this.writeToServletError(resp, RestStatus.BAD_REQUEST, e.toString());
            return;
        }
        final AsyncContext ctx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ctx.setTimeout(this._timeout);
        ctx.addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
                AsyncContext ctx2 = event.getAsyncContext();
                AbstractAsyncR2Servlet.this.writeToServletError((HttpServletResponse)ctx2.getResponse(), RestStatus.INTERNAL_SERVER_ERROR, "Server Timeout");
                ctx2.complete();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
                AbstractAsyncR2Servlet.this.writeToServletError((HttpServletResponse)event.getSuppliedResponse(), RestStatus.INTERNAL_SERVER_ERROR, "Server Error");
                ctx.complete();
            }

            public void onComplete(AsyncEvent event) throws IOException {
                Object exception = req.getAttribute(AbstractAsyncR2Servlet.TRANSPORT_CALLBACK_IOEXCEPTION);
                if (exception != null) {
                    throw new IOException((IOException)exception);
                }
            }
        });
        TransportCallback<RestResponse> callback = new TransportCallback<RestResponse>(){

            @Override
            public void onResponse(final TransportResponse<RestResponse> response) {
                ctx.start(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractAsyncR2Servlet.this.writeToServletResponse(response, (HttpServletResponse)ctx.getResponse());
                        }
                        catch (IOException e) {
                            req.setAttribute(AbstractAsyncR2Servlet.TRANSPORT_CALLBACK_IOEXCEPTION, (Object)e);
                        }
                        finally {
                            ctx.complete();
                        }
                    }
                });
            }
        };
        this.getDispatcher().handleRequest(restRequest, requestContext, callback);
    }

    public long getTimeout() {
        return this._timeout;
    }
}

