/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.util.Timeout;
import com.linkedin.r2.util.TimeoutExecutor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutTransportCallback<T>
implements TransportCallback<T>,
TimeoutExecutor {
    private final Timeout<TransportCallback<T>> _timeout;

    public TimeoutTransportCallback(ScheduledExecutorService scheduler, long timeout, TimeUnit timeoutUnit, final TransportCallback<T> callback, final String timeoutMessage) {
        this._timeout = new Timeout<TransportCallback<TransportCallback<T>>>(scheduler, timeout, timeoutUnit, callback);
        this._timeout.addTimeoutTask(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(TransportResponseImpl.error(new TimeoutException(timeoutMessage)));
            }
        });
    }

    @Override
    public void onResponse(TransportResponse<T> response) {
        TransportCallback<T> callback = this._timeout.getItem();
        if (callback != null) {
            callback.onResponse(response);
        }
    }

    @Override
    public void addTimeoutTask(Runnable task) {
        this._timeout.addTimeoutTask(task);
    }
}

