/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common.bridge.server;

import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.DrainReader;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.common.bridge.server.TransportCallbackAdapter;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TransportDispatcherImpl
implements TransportDispatcher {
    private final Map<URI, StreamRequestHandler> _streamHandlers;
    private final Map<URI, RestRequestHandler> _restHandlers;

    TransportDispatcherImpl(Map<URI, RestRequestHandler> restHandlers, Map<URI, StreamRequestHandler> streamHandlers) {
        this._streamHandlers = streamHandlers == null ? Collections.emptyMap() : new HashMap<URI, StreamRequestHandler>(streamHandlers);
        this._restHandlers = restHandlers == null ? Collections.emptyMap() : new HashMap<URI, RestRequestHandler>(restHandlers);
    }

    @Override
    public void handleRestRequest(RestRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<RestResponse> callback) {
        URI address = req.getURI();
        RestRequestHandler handler = this._restHandlers.get(address);
        if (handler == null) {
            callback.onResponse(TransportResponseImpl.success(RestStatus.responseForStatus(RestStatus.NOT_FOUND, "No resource for URI:" + address)));
            return;
        }
        try {
            handler.handleRequest(req, requestContext, new TransportCallbackAdapter<RestResponse>(callback));
        }
        catch (Exception e) {
            callback.onResponse(TransportResponseImpl.error(RestException.forError(RestStatus.INTERNAL_SERVER_ERROR, e)));
        }
    }

    @Override
    public void handleStreamRequest(StreamRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<StreamResponse> callback) {
        URI address = req.getURI();
        StreamRequestHandler handler = this._streamHandlers.get(address);
        if (handler == null) {
            RestResponse response = RestStatus.responseForStatus(RestStatus.NOT_FOUND, "No resource for URI: " + address);
            callback.onResponse(TransportResponseImpl.success(Messages.toStreamResponse(response)));
            req.getEntityStream().setReader(new DrainReader());
            return;
        }
        try {
            handler.handleRequest(req, requestContext, new TransportCallbackAdapter<StreamResponse>(callback));
        }
        catch (Exception e) {
            RestException ex = RestException.forError(RestStatus.INTERNAL_SERVER_ERROR, e);
            callback.onResponse(TransportResponseImpl.error(ex));
        }
    }
}

