/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common.bridge.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.AbstractClient;
import com.linkedin.r2.transport.common.bridge.client.TransportCallbackAdapter;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.util.HashMap;

public class TransportClientAdapter
extends AbstractClient {
    private final TransportClient _client;
    private final boolean _restOverStream;

    public TransportClientAdapter(TransportClient client) {
        this(client, false);
    }

    public TransportClientAdapter(TransportClient client, boolean restOverStream) {
        this._client = client;
        this._restOverStream = restOverStream;
    }

    @Override
    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        HashMap<String, String> wireAttrs = new HashMap<String, String>();
        this._client.streamRequest(request, new RequestContext(requestContext), wireAttrs, new TransportCallbackAdapter<StreamResponse>(callback));
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (!this._restOverStream) {
            HashMap<String, String> wireAttrs = new HashMap<String, String>();
            this._client.restRequest(request, new RequestContext(requestContext), wireAttrs, new TransportCallbackAdapter<RestResponse>(callback));
        } else {
            super.restRequest(request, requestContext, callback);
        }
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._client.shutdown(callback);
    }
}

