/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.util.ArgumentUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class ByteStringWriter
implements Writer {
    private final ByteString _content;
    private final AtomicBoolean _done;
    private WriteHandle _wh;

    public ByteStringWriter(ByteString content) {
        ArgumentUtil.notNull((Object)content, (String)"content");
        this._content = content;
        this._done = new AtomicBoolean(false);
    }

    @Override
    public void onInit(WriteHandle wh) {
        this._wh = wh;
    }

    @Override
    public void onWritePossible() {
        while (this._wh.remaining() > 0) {
            if (this._done.compareAndSet(false, true)) {
                this._wh.write(this._content);
                continue;
            }
            this._wh.done();
            break;
        }
    }

    @Override
    public void onAbort(Throwable ex) {
    }
}

