/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;

public class BaseConnector
implements Reader,
Writer {
    private volatile WriteHandle _wh;
    private volatile ReadHandle _rh;
    private int _outstanding = 0;
    private volatile boolean _aborted = false;
    private volatile Throwable _error;

    @Override
    public void onInit(ReadHandle rh) {
        this._rh = this.wrapReadHandle(rh);
    }

    @Override
    public void onInit(WriteHandle wh) {
        this._wh = this.wrapWriteHandle(wh);
    }

    @Override
    public void onDataAvailable(ByteString data) {
        if (!this._aborted) {
            --this._outstanding;
            this._wh.write(data);
            int diff = this._wh.remaining() - this._outstanding;
            if (diff > 0) {
                this._rh.request(diff);
                this._outstanding += diff;
            }
        }
    }

    @Override
    public void onDone() {
        this._wh.done();
    }

    @Override
    public void onError(Throwable e) {
        if (this._wh != null) {
            this._wh.error(e);
        } else {
            this._error = e;
        }
    }

    @Override
    public void onWritePossible() {
        if (this._error == null) {
            this._outstanding = this._wh.remaining();
            this._rh.request(this._outstanding);
        } else {
            this._wh.error(this._error);
        }
    }

    @Override
    public void onAbort(Throwable e) {
        this._aborted = true;
        this._rh.cancel();
    }

    public void cancel() {
        if (this._rh != null) {
            this._rh.cancel();
        }
    }

    protected WriteHandle wrapWriteHandle(WriteHandle wh) {
        return wh;
    }

    protected ReadHandle wrapReadHandle(ReadHandle rh) {
        return rh;
    }

    protected final WriteHandle getWriteHandle() {
        return this._wh;
    }

    protected final ReadHandle getReadHandle() {
        return this._rh;
    }
}

