/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.BaseResponse;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.util.ArgumentUtil;
import java.util.List;
import java.util.Map;

final class RestResponseImpl
extends BaseResponse
implements RestResponse {
    private final ByteString _entity;

    RestResponseImpl(ByteString entity, Map<String, String> headers, List<String> cookies, int status) {
        super(headers, cookies, status);
        ArgumentUtil.notNull((Object)entity, (String)"entity");
        this._entity = entity;
    }

    @Override
    public ByteString getEntity() {
        return this._entity;
    }

    @Override
    public RestResponseBuilder builder() {
        return new RestResponseBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestResponseImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestResponseImpl that = (RestResponseImpl)o;
        return this._entity.equals((Object)that._entity);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._entity.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RestResponse[headers=").append(this.getHeaders()).append("cookies=").append(this.getCookies()).append(",status=").append(this.getStatus()).append(",entityLength=").append(this._entity.length()).append("]");
        return builder.toString();
    }
}

