/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.BaseResponseBuilder;
import com.linkedin.r2.message.rest.RestMessageBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseImpl;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.util.ArgumentUtil;

public final class RestResponseBuilder
extends BaseResponseBuilder<RestResponseBuilder>
implements RestMessageBuilder<RestResponseBuilder> {
    private ByteString _entity = ByteString.empty();

    public RestResponseBuilder() {
    }

    public RestResponseBuilder(RestResponse response) {
        super(response);
        this._entity = response.getEntity();
    }

    public RestResponseBuilder(StreamResponse response) {
        super(response);
    }

    @Override
    public RestResponseBuilder setEntity(ByteString entity) {
        ArgumentUtil.notNull((Object)entity, (String)"entity");
        this._entity = entity;
        return this;
    }

    @Override
    public RestResponseBuilder setEntity(byte[] entity) {
        ArgumentUtil.notNull((Object)entity, (String)"entity");
        this._entity = ByteString.copy((byte[])entity);
        return this;
    }

    @Override
    public ByteString getEntity() {
        return this._entity;
    }

    @Override
    public RestResponse build() {
        return new RestResponseImpl(this._entity, this.getHeaders(), this.getCookies(), this.getStatus());
    }

    @Override
    public RestResponse buildCanonical() {
        return new RestResponseImpl(this._entity, this.getCanonicalHeaders(), this.getCanonicalCookies(), this.getStatus());
    }
}

