/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.r2.RetriableRequestException;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRetryFilter
implements RestFilter,
StreamFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRetryFilter.class);

    @Override
    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this.processError(ex, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onStreamError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        this.processError(ex, requestContext, wireAttrs, nextFilter);
    }

    private <REQ extends Request, RES extends Response> void processError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<REQ, RES> nextFilter) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof RetriableRequestException)) continue;
            String message = cause.getMessage();
            LOG.debug("RetriableRequestException caught! Error message: {}", (Object)message);
            wireAttrs.put("RETRY", message);
            break;
        }
        nextFilter.onError(ex, requestContext, wireAttrs);
    }
}

