/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep.db;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class DirectoryDbUtil {
    private static final String REQ_SUFFIX = ".req";
    private static final String RES_SUFFIX = ".res";
    private static final String REST_SUFFIX = ".rest";
    private static final String RPC_SUFFIX = ".rpc";

    public static File requestFileName(File dir, String id) {
        return new File(dir.getAbsolutePath() + File.separator + id + REQ_SUFFIX);
    }

    @Deprecated
    public static File rpcRequestFileName(File dir, int id) {
        return new File(dir.getAbsolutePath() + File.separator + id + RPC_SUFFIX + REQ_SUFFIX);
    }

    public static File restRequestFileName(File dir, int id) {
        return new File(dir.getAbsolutePath() + File.separator + id + REST_SUFFIX + REQ_SUFFIX);
    }

    public static File responseFileName(File dir, String id) {
        return new File(dir.getAbsolutePath() + File.separator + id + RES_SUFFIX);
    }

    @Deprecated
    public static File rpcResponseFileName(File dir, int id) {
        return new File(dir.getAbsolutePath() + File.separator + id + RPC_SUFFIX + RES_SUFFIX);
    }

    public static File restResponseFileName(File dir, int id) {
        return new File(dir.getAbsolutePath() + File.separator + id + REST_SUFFIX + RES_SUFFIX);
    }

    public static String[] listRequestIds(File dir) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isFile() && name.endsWith(DirectoryDbUtil.REQ_SUFFIX) && (DirectoryDbUtil.stripSuffix(name, DirectoryDbUtil.REQ_SUFFIX).endsWith(DirectoryDbUtil.REST_SUFFIX) || DirectoryDbUtil.stripSuffix(name, DirectoryDbUtil.REQ_SUFFIX).endsWith(DirectoryDbUtil.RPC_SUFFIX));
            }
        });
        if (files == null) {
            throw new IOException("Path is not a directory or an IO error occurred while reading: " + dir);
        }
        String[] ids = new String[files.length];
        for (int i = 0; i < ids.length; ++i) {
            String name = files[i].getName();
            ids[i] = DirectoryDbUtil.stripSuffix(name, REQ_SUFFIX);
        }
        return ids;
    }

    public static int getIndex(String id) {
        int dotIndex = id.indexOf(46);
        if (dotIndex != -1) {
            id = id.substring(0, dotIndex);
        }
        return Integer.parseInt(id);
    }

    private static String stripSuffix(String str, String suffix) {
        return str.substring(0, str.length() - suffix.length());
    }
}

