/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep.db;

import com.linkedin.data.ByteString;
import com.linkedin.r2.caprep.db.MessageSerializer;
import com.linkedin.r2.message.MessageHeaders;
import com.linkedin.r2.message.MessageHeadersBuilder;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;

public class DefaultMessageSerializer
implements MessageSerializer {
    private static final Charset CHARSET = Charset.forName("ASCII");
    private static final char CR_CHAR = '\r';
    private static final char LF_CHAR = '\n';
    private static final String CR = Character.toString('\r');
    private static final String LF = Character.toString('\n');
    private static final String CRLF = CR + LF;
    private static final char SP_CHAR = ' ';
    private static final String SP = Character.toString(' ');
    private static final String HT = "\t";
    private static final String POST = "POST";
    private static final String HTTP_1_1 = "HTTP/1.1";
    private static final String STATUS_200 = "200";

    @Override
    public void writeRequest(OutputStream out, RestRequest req) throws IOException {
        this.writeReqLine(out, req);
        this.writeHeaders(out, req, "Cookie");
        this.writeEntity(out, req);
    }

    @Override
    public void writeResponse(OutputStream out, RestResponse res) throws IOException {
        this.writeResLine(out, res);
        this.writeHeaders(out, res, "Set-Cookie");
        this.writeEntity(out, res);
    }

    @Override
    public RestRequest readRestRequest(InputStream in) throws IOException {
        RestRequestBuilder builder = new RestRequestBuilder(URI.create(""));
        this.readReqLine(builder, in);
        this.readHeaders(builder, in, "Cookie");
        builder.setEntity(this.readEntity(in));
        return builder.build();
    }

    @Override
    public RestResponse readRestResponse(InputStream in) throws IOException {
        RestResponseBuilder builder = new RestResponseBuilder();
        this.readResLine(builder, in);
        this.readHeaders(builder, in, "Set-Cookie");
        builder.setEntity(this.readEntity(in));
        return builder.build();
    }

    private void readReqLine(RestRequestBuilder builder, InputStream in) throws IOException {
        builder.setMethod(this.readUntil(' ', in));
        builder.setURI(URI.create(this.readUntil(' ', in)));
        this.readIgnore(HTTP_1_1, in);
        this.readIgnoreNewLine(in);
    }

    private void readResLine(RestResponseBuilder builder, InputStream in) throws IOException {
        this.readIgnore(HTTP_1_1, in);
        this.readIgnore(SP, in);
        try {
            String statusStr = this.readUntil(' ', in);
            builder.setStatus(Integer.parseInt(statusStr));
        }
        catch (NumberFormatException e) {
            throw new IOException("Failed to parse HTTP status code", e);
        }
        this.readIgnoreLine(in);
    }

    private void readHeaders(MessageHeadersBuilder<?> builder, InputStream in, String cookieHeader) throws IOException {
        String line = this.readLine(in);
        while (!line.isEmpty()) {
            int sep = line.indexOf(58);
            if (sep == -1) {
                throw new IOException("Parsing header failed. Expected ':' in: " + this.printable(line));
            }
            String key = line.substring(0, sep);
            StringBuilder valueBuilder = new StringBuilder(line.substring(sep + 1));
            line = this.readLine(in);
            while (line.startsWith(SP) || line.startsWith(HT)) {
                valueBuilder.append(line);
                line = this.readLine(in);
            }
            if (key.equalsIgnoreCase(cookieHeader)) {
                builder.addCookie(valueBuilder.toString().trim());
                continue;
            }
            builder.addHeaderValue(key, valueBuilder.toString().trim());
        }
    }

    private ByteString readEntity(InputStream in) throws IOException {
        int bytesRead;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        byte[] eb = out.toByteArray();
        ByteString entity = eb.length >= 2 && eb[eb.length - 2] == 13 && eb[eb.length - 1] == 10 ? ByteString.copy((byte[])eb, (int)0, (int)(eb.length - 2)) : ByteString.copy((byte[])eb);
        return entity;
    }

    private void writeReqLine(OutputStream out, Request req) throws IOException {
        if (req instanceof RestRequest) {
            this.write(out, ((RestRequest)req).getMethod());
        } else {
            this.write(out, POST);
        }
        this.write(out, SP);
        this.write(out, req.getURI().toASCIIString());
        this.write(out, SP);
        this.write(out, HTTP_1_1);
        this.write(out, CRLF);
    }

    private void writeResLine(OutputStream out, Response res) throws IOException {
        int statusCode;
        this.write(out, HTTP_1_1);
        this.write(out, SP);
        if (res instanceof RestResponse) {
            statusCode = ((RestResponse)res).getStatus();
            this.write(out, Integer.toString(statusCode));
        } else {
            statusCode = 200;
            this.write(out, STATUS_200);
        }
        this.write(out, SP);
        this.write(out, this.toReasonPhrase(statusCode));
        this.write(out, CRLF);
    }

    private String toReasonPhrase(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 306: {
                return "Switch Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return "No Reason Phrase";
    }

    private void writeHeaders(OutputStream out, MessageHeaders msg, String cookieHeader) throws IOException {
        for (Map.Entry<String, String> hdr : msg.getHeaders().entrySet()) {
            this.writeHeader(out, hdr.getKey(), hdr.getValue());
        }
        for (String cookie : msg.getCookies()) {
            this.writeHeader(out, cookieHeader, cookie);
        }
        this.write(out, CRLF);
    }

    private void writeHeader(OutputStream out, String key, String value) throws IOException {
        this.write(out, key);
        this.write(out, ":");
        this.write(out, SP);
        this.write(out, value.replaceAll("[\n\r]+", " "));
        this.write(out, CRLF);
    }

    private void readIgnore(String expectedStr, InputStream in) throws IOException {
        int bytesRead;
        int bytesExpected = expectedStr.getBytes(CHARSET).length;
        byte[] actualBytes = new byte[bytesExpected];
        String actualStr = new String(actualBytes, 0, bytesRead = in.read(actualBytes), CHARSET);
        if (!actualStr.equalsIgnoreCase(expectedStr)) {
            throw new IOException("Parse failed. Expected: " + this.printable(expectedStr) + ". Actual: " + this.printable(actualStr));
        }
    }

    private String readUntil(char ch, InputStream in) throws IOException {
        int nextByte;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((nextByte = in.read()) != ch) {
            if (nextByte == -1) {
                throw new IOException("Parse failed. End of stream before reaching expected char: " + this.printable(ch));
            }
            out.write(nextByte);
        }
        return new String(out.toByteArray(), CHARSET);
    }

    private void readIgnoreNewLine(InputStream in) throws IOException {
        char ch = (char)in.read();
        if (ch == '\r') {
            ch = (char)in.read();
        }
        if (ch == '\uffffffff') {
            throw new IOException("Expected end-of-line but got EOF");
        }
        if (ch != '\n') {
            throw new IOException("Expected LF (0x0A) but got EOF");
        }
    }

    private void readIgnoreLine(InputStream in) throws IOException {
        this.readLine(in);
    }

    private String readLine(InputStream in) throws IOException {
        return this.readUntil('\n', in).replaceAll(CR, "");
    }

    private void writeEntity(OutputStream out, RestMessage res) throws IOException {
        res.getEntity().write(out);
        this.write(out, CRLF);
    }

    private void write(OutputStream out, String text) throws IOException {
        out.write(text.getBytes(CHARSET));
    }

    private String printable(String str) {
        StringBuilder sb = new StringBuilder();
        for (byte b : str.getBytes(CHARSET)) {
            sb.append(this.printable((char)b));
        }
        return sb.toString();
    }

    private String printable(char ch) {
        if (ch >= ' ' && ch <= '~') {
            return Character.toString(ch);
        }
        return " (0x" + Integer.toHexString(ch) + ") ";
    }
}

