/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep;

import com.linkedin.r2.caprep.db.DbSource;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayFilter
implements RestFilter {
    private static final Logger _log = LoggerFactory.getLogger(ReplayFilter.class);
    private final DbSource _db;

    public ReplayFilter(DbSource db) {
        this._db = db;
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        if (!this.replayResponse(req, requestContext, nextFilter)) {
            nextFilter.onRequest(req, requestContext, wireAttrs);
        }
    }

    private boolean replayResponse(RestRequest req, RequestContext requestContext, NextFilter<RestRequest, RestResponse> nextFilter) {
        RestResponse res = this._db.replay(req);
        if (res != null) {
            _log.debug("Using cached response for request: " + req.getURI());
            HashMap<String, String> wireAttrs = new HashMap<String, String>();
            if (!RestStatus.isOK(res.getStatus())) {
                nextFilter.onError(new RestException(res), requestContext, wireAttrs);
            } else {
                nextFilter.onResponse(res, requestContext, wireAttrs);
            }
            return true;
        }
        return false;
    }
}

