/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep;

import com.linkedin.r2.caprep.db.DbSink;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureFilter
implements RestFilter {
    private static final Logger _log = LoggerFactory.getLogger(CaptureFilter.class);
    private static final String REQ_ATTR = CaptureFilter.class.getName() + ".req";
    private final DbSink _db;

    public CaptureFilter(DbSink db) {
        this._db = db;
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        requestContext.putLocalAttr(REQ_ATTR, req);
        nextFilter.onRequest(req, requestContext, wireAttrs);
    }

    @Override
    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this.saveResponse(res, requestContext);
        nextFilter.onResponse(res, requestContext, wireAttrs);
    }

    @Override
    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        if (ex instanceof RestException) {
            this.saveResponse(((RestException)ex).getResponse(), requestContext);
        }
        nextFilter.onError(ex, requestContext, wireAttrs);
    }

    private void saveResponse(RestResponse res, RequestContext requestContext) {
        RestRequest req = (RestRequest)requestContext.removeLocalAttr(REQ_ATTR);
        if (req != null) {
            _log.debug("Saving response for request: " + req.getURI());
            try {
                this._db.record(req, res);
            }
            catch (IOException e) {
                _log.debug("Failed to save request", (Throwable)e);
            }
        }
    }
}

