/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.inject.Inject;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import com.linkedin.restli.server.PagingContext;
import com.linkedin.restli.server.annotations.Context;
import com.linkedin.restli.server.annotations.Finder;
import com.linkedin.restli.server.annotations.QueryParam;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.resources.ComplexKeyResourceTemplate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.apache.gobblin.service.ExecutionStatus;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.FlowStatistics;
import org.apache.gobblin.service.FlowStatusId;
import org.apache.gobblin.service.JobId;
import org.apache.gobblin.service.JobState;
import org.apache.gobblin.service.JobStatistics;
import org.apache.gobblin.service.JobStatus;
import org.apache.gobblin.service.JobStatusArray;
import org.apache.gobblin.service.monitoring.FlowStatus;
import org.apache.gobblin.service.monitoring.FlowStatusGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestLiCollection(name="flowstatuses", namespace="org.apache.gobblin.service", keyName="id")
public class FlowStatusResource
extends ComplexKeyResourceTemplate<FlowStatusId, EmptyRecord, org.apache.gobblin.service.FlowStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStatusResource.class);
    public static final String FLOW_STATUS_GENERATOR_INJECT_NAME = "FlowStatusGenerator";
    public static final String MESSAGE_SEPARATOR = ", ";
    @Inject
    @javax.inject.Inject
    @Named(value="FlowStatusGenerator")
    FlowStatusGenerator _flowStatusGenerator;

    public org.apache.gobblin.service.FlowStatus get(ComplexResourceKey<FlowStatusId, EmptyRecord> key) {
        String flowGroup = ((FlowStatusId)key.getKey()).getFlowGroup();
        String flowName = ((FlowStatusId)key.getKey()).getFlowName();
        long flowExecutionId = ((FlowStatusId)key.getKey()).getFlowExecutionId();
        LOG.info("Get called with flowGroup " + flowGroup + " flowName " + flowName + " flowExecutionId " + flowExecutionId);
        FlowStatus flowStatus = this._flowStatusGenerator.getFlowStatus(flowName, flowGroup, flowExecutionId);
        return this.convertFlowStatus(flowStatus);
    }

    @Finder(value="latestFlowStatus")
    public List<org.apache.gobblin.service.FlowStatus> getLatestFlowStatus(@Context PagingContext context, @QueryParam(value="flowId") FlowId flowId) {
        LOG.info("getLatestFlowStatus called with flowGroup " + flowId.getFlowGroup() + " flowName " + flowId.getFlowName());
        FlowStatus latestFlowStatus = this._flowStatusGenerator.getLatestFlowStatus(flowId.getFlowName(), flowId.getFlowGroup());
        if (latestFlowStatus != null) {
            return Collections.singletonList(this.convertFlowStatus(latestFlowStatus));
        }
        return null;
    }

    private org.apache.gobblin.service.FlowStatus convertFlowStatus(FlowStatus monitoringFlowStatus) {
        if (monitoringFlowStatus == null) {
            return null;
        }
        Iterator jobStatusIter = monitoringFlowStatus.getJobStatusIterator();
        JobStatusArray jobStatusArray = new JobStatusArray();
        FlowId flowId = new FlowId().setFlowName(monitoringFlowStatus.getFlowName()).setFlowGroup(monitoringFlowStatus.getFlowGroup());
        long flowStartTime = Long.MAX_VALUE;
        long flowEndTime = -1L;
        ExecutionStatus flowExecutionStatus = ExecutionStatus.COMPLETE;
        StringBuffer flowMessagesStringBuffer = new StringBuffer();
        while (jobStatusIter.hasNext()) {
            org.apache.gobblin.service.monitoring.JobStatus queriedJobStatus = (org.apache.gobblin.service.monitoring.JobStatus)jobStatusIter.next();
            JobStatus jobStatus = new JobStatus();
            jobStatus.setFlowId(flowId).setJobId(new JobId().setJobName(queriedJobStatus.getJobName()).setJobGroup(queriedJobStatus.getJobGroup())).setExecutionStatistics(new JobStatistics().setExecutionStartTime(queriedJobStatus.getStartTime()).setExecutionEndTime(queriedJobStatus.getEndTime()).setProcessedCount(queriedJobStatus.getProcessedCount())).setExecutionStatus(this.timingEventToStatus(queriedJobStatus.getEventName())).setMessage(queriedJobStatus.getMessage()).setJobState(new JobState().setLowWatermark(queriedJobStatus.getLowWatermark()).setHighWatermark(queriedJobStatus.getHighWatermark()));
            jobStatusArray.add((DataTemplate)jobStatus);
            if (queriedJobStatus.getStartTime() < flowStartTime) {
                flowStartTime = queriedJobStatus.getStartTime();
            }
            if (queriedJobStatus.getEndTime() > flowEndTime) {
                flowEndTime = queriedJobStatus.getEndTime();
            }
            if (!queriedJobStatus.getMessage().isEmpty()) {
                flowMessagesStringBuffer.append(queriedJobStatus.getMessage());
                flowMessagesStringBuffer.append(MESSAGE_SEPARATOR);
            }
            flowExecutionStatus = this.updatedFlowExecutionStatus(jobStatus.getExecutionStatus(), flowExecutionStatus);
        }
        String flowMessages = flowMessagesStringBuffer.length() > 0 ? flowMessagesStringBuffer.substring(0, flowMessagesStringBuffer.length() - MESSAGE_SEPARATOR.length()) : "";
        return new org.apache.gobblin.service.FlowStatus().setId(new FlowStatusId().setFlowGroup(flowId.getFlowGroup()).setFlowName(flowId.getFlowName()).setFlowExecutionId(monitoringFlowStatus.getFlowExecutionId())).setExecutionStatistics(new FlowStatistics().setExecutionStartTime(flowStartTime).setExecutionEndTime(flowEndTime)).setMessage(flowMessages).setExecutionStatus(flowExecutionStatus).setJobStatuses(jobStatusArray);
    }

    private ExecutionStatus timingEventToStatus(String timingEvent) {
        ExecutionStatus status;
        switch (timingEvent) {
            case "JobFailedTimer": 
            case "JobCancelTimer": {
                status = ExecutionStatus.FAILED;
                break;
            }
            case "JobCompleteTimer": {
                status = ExecutionStatus.COMPLETE;
                break;
            }
            default: {
                status = ExecutionStatus.RUNNING;
            }
        }
        return status;
    }

    private ExecutionStatus updatedFlowExecutionStatus(ExecutionStatus jobExecutionStatus, ExecutionStatus currentFlowExecutionStatus) {
        if (currentFlowExecutionStatus == ExecutionStatus.FAILED || jobExecutionStatus == ExecutionStatus.FAILED) {
            return ExecutionStatus.FAILED;
        }
        if (jobExecutionStatus == ExecutionStatus.RUNNING) {
            return ExecutionStatus.RUNNING;
        }
        return currentFlowExecutionStatus;
    }
}

