/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpSender;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;

public class SendLinkHandler
extends BaseLinkHandler {
    private final IAmqpSender msgSender;
    private final Object firstFlow;
    private boolean isFirstFlow;

    public SendLinkHandler(IAmqpSender sender) {
        super(sender);
        this.msgSender = sender;
        this.firstFlow = new Object();
        this.isFirstFlow = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link != null && link instanceof Sender) {
            Sender sender = (Sender)link;
            if (link.getRemoteTarget() != null) {
                if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                    TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "linkName[%s], remoteTarget[%s]", sender.getName(), link.getRemoteTarget()));
                }
                Object object = this.firstFlow;
                synchronized (object) {
                    this.isFirstFlow = false;
                    this.msgSender.onOpenComplete(null);
                }
            } else if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "linkName[%s], remoteTarget[null], remoteSource[null], action[waitingForError]", sender.getName()));
            }
        }
    }

    public void onDelivery(Event event) {
        Delivery delivery = event.getDelivery();
        while (delivery != null) {
            Sender sender = (Sender)delivery.getLink();
            if (TRACE_LOGGER.isLoggable(Level.FINEST)) {
                TRACE_LOGGER.log(Level.FINEST, "linkName[" + sender.getName() + "], unsettled[" + sender.getUnsettled() + "], credit[" + sender.getRemoteCredit() + "], deliveryState[" + delivery.getRemoteState() + "], delivery.isBuffered[" + delivery.isBuffered() + "], delivery.id[" + new String(delivery.getTag()) + "]");
            }
            this.msgSender.onSendComplete(delivery);
            delivery.settle();
            delivery = sender.current();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkFlow(Event event) {
        if (this.isFirstFlow) {
            Object object = this.firstFlow;
            synchronized (object) {
                if (this.isFirstFlow) {
                    this.msgSender.onOpenComplete(null);
                    this.isFirstFlow = false;
                }
            }
        }
        Sender sender = event.getSender();
        this.msgSender.onFlow(sender.getRemoteCredit());
        if (TRACE_LOGGER.isLoggable(Level.FINEST)) {
            TRACE_LOGGER.log(Level.FINEST, "linkName[" + sender.getName() + "], unsettled[" + sender.getUnsettled() + "], credit[" + sender.getCredit() + "]");
        }
    }
}

