/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import org.apache.gobblin.annotation.Alpha;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.tools.ClusterSetup;

@Alpha
public class HelixUtils {
    public static void createGobblinHelixCluster(String zkConnectionString, String clusterName) {
        HelixUtils.createGobblinHelixCluster(zkConnectionString, clusterName, true);
    }

    public static void createGobblinHelixCluster(String zkConnectionString, String clusterName, boolean overwrite) {
        ClusterSetup clusterSetup = new ClusterSetup(zkConnectionString);
        clusterSetup.addCluster(clusterName, overwrite);
        String autoJoinConfig = "allowParticipantAutoJoin=true";
        clusterSetup.setConfig(HelixConfigScope.ConfigScopeProperty.CLUSTER, clusterName, autoJoinConfig);
    }

    public static String getHelixInstanceName(String namePrefix, int instanceId) {
        return namePrefix + "_" + instanceId;
    }
}

