/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;

public class GobblinHelixTaskDriver {
    private final TaskDriver _taskDriver;

    public GobblinHelixTaskDriver(HelixManager manager) {
        this(manager.getClusterManagmentTool(), manager.getHelixDataAccessor(), manager.getConfigAccessor(), (HelixPropertyStore<ZNRecord>)manager.getHelixPropertyStore(), manager.getClusterName());
    }

    public GobblinHelixTaskDriver(HelixAdmin admin, HelixDataAccessor accessor, ConfigAccessor cfgAccessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this._taskDriver = new TaskDriver(admin, accessor, cfgAccessor, propertyStore, clusterName);
    }

    public void deleteWorkflow(String workflow, long timeout) throws InterruptedException {
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(workflow);
        if (workflowConfig != null && workflowConfig.getTargetState() != TargetState.DELETE) {
            this._taskDriver.delete(workflow);
        }
        long endTime = System.currentTimeMillis() + timeout * 1000L;
        while (System.currentTimeMillis() <= endTime) {
            WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(workflow);
            if (workflowContext != null) {
                Thread.sleep(1000L);
                continue;
            }
            return;
        }
        throw new HelixException(String.format("Fail to delete the workflow/queue %s within %d seconds.", workflow, timeout));
    }
}

