/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.gobblin.util.executors.MDCPropagatingCallable;
import org.apache.gobblin.util.executors.MDCPropagatingRunnable;

public class MDCPropagatingExecutorService
extends ForwardingListeningExecutorService {
    private ListeningExecutorService executorService;

    public MDCPropagatingExecutorService(ExecutorService executorService) {
        this.executorService = executorService instanceof ListeningExecutorService ? (ListeningExecutorService)executorService : MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    protected ListeningExecutorService delegate() {
        return this.executorService;
    }

    public void execute(Runnable command) {
        super.execute((Runnable)new MDCPropagatingRunnable(command));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return super.submit(new MDCPropagatingCallable<T>(task));
    }

    public ListenableFuture<?> submit(Runnable task) {
        return super.submit((Runnable)new MDCPropagatingRunnable(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return super.submit((Runnable)new MDCPropagatingRunnable(task), result);
    }
}

