/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.concurrent.CancellableTask;
import org.apache.gobblin.util.concurrent.ScheduledTask;
import org.apache.gobblin.util.concurrent.TaskScheduler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class HashedWheelTimerTaskScheduler<K, T extends ScheduledTask<K>>
extends TaskScheduler<K, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashedWheelTimerTaskScheduler.class);
    private static HashedWheelTimer executor = new HashedWheelTimer(ExecutorsUtils.newDaemonThreadFactory((Optional<Logger>)Optional.of((Object)LOGGER), (Optional<String>)Optional.of((Object)"HashedWheelTimerTaskScheduler")));

    HashedWheelTimerTaskScheduler() {
    }

    @Override
    final void startImpl(Optional<String> name) {
    }

    @Override
    final CancellableTask<K, T> scheduleImpl(T task, long period, TimeUnit unit) {
        return new HashedWheelTimerTask(this, executor, task, period, unit);
    }

    @Override
    final void closeImpl() throws IOException {
        for (ScheduledTask scheduledTask : this.getScheduledTasks()) {
            this.cancel(scheduledTask);
        }
    }

    private class HashedWheelTimerTask<K2, T2 extends ScheduledTask<K2>>
    extends CancellableTask<K2, T2>
    implements TimerTask {
        private final Object $lock;
        private final HashedWheelTimer timer;
        private final T2 task;
        private final long period;
        private final TimeUnit unit;
        private final Map<String, String> context;
        private volatile Timeout future;
        final /* synthetic */ HashedWheelTimerTaskScheduler this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        HashedWheelTimerTask(HashedWheelTimer period, T2 T2, long unit, TimeUnit timeUnit) {
            void timer;
            this.this$0 = (HashedWheelTimerTaskScheduler)l;
            super(task);
            this.$lock = new Object[0];
            this.timer = timer;
            this.task = task;
            this.period = period;
            this.unit = (TimeUnit)unit;
            this.context = MDC.getCopyOfContextMap();
            this.future = this.timer.newTimeout((TimerTask)this, this.period, this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) throws Exception {
            Object object = this.$lock;
            synchronized (object) {
                Map originalContext = MDC.getCopyOfContextMap();
                if (this.context != null) {
                    MDC.setContextMap(this.context);
                }
                try {
                    this.task.runOneIteration();
                }
                finally {
                    if (this.future != null) {
                        this.future = this.timer.newTimeout((TimerTask)this, this.period, this.unit);
                    }
                    if (originalContext != null) {
                        MDC.setContextMap((Map)originalContext);
                    } else {
                        MDC.clear();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Object object = this.$lock;
            synchronized (object) {
                if (this.future != null) {
                    this.future.cancel();
                    this.future = null;
                }
                return true;
            }
        }
    }
}

