/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ImmutableProperties
extends Properties {
    private final Map<Object, Object> props;

    public ImmutableProperties(Properties props) {
        this.props = Collections.unmodifiableMap(props);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableProperties that = (ImmutableProperties)o;
        return this.props != null ? this.props.equals(that.props) : that.props == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
        return result;
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.props.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.props.containsValue(arg0);
    }

    @Override
    public Object get(Object arg0) {
        return this.props.get(arg0);
    }

    @Override
    public Object put(Object arg0, Object arg1) {
        return this.props.put(arg0, arg1);
    }

    @Override
    public Object remove(Object arg0) {
        return this.props.remove(arg0);
    }

    @Override
    public void putAll(Map<?, ?> arg0) {
        this.props.putAll(arg0);
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.props.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.props.entrySet();
    }

    @Override
    public Object getOrDefault(Object arg0, Object arg1) {
        return this.props.getOrDefault(arg0, arg1);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> arg0) {
        this.props.forEach(arg0);
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ?> arg0) {
        this.props.replaceAll(arg0);
    }

    @Override
    public Object putIfAbsent(Object arg0, Object arg1) {
        return this.props.putIfAbsent(arg0, arg1);
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        return this.props.remove(arg0, arg1);
    }

    @Override
    public boolean replace(Object arg0, Object arg1, Object arg2) {
        return this.props.replace(arg0, arg1, arg2);
    }

    @Override
    public Object replace(Object arg0, Object arg1) {
        return this.props.replace(arg0, arg1);
    }

    @Override
    public Object computeIfAbsent(Object arg0, Function<? super Object, ?> arg1) {
        return this.props.computeIfAbsent(arg0, arg1);
    }

    @Override
    public Object computeIfPresent(Object arg0, BiFunction<? super Object, ? super Object, ?> arg1) {
        return this.props.computeIfPresent(arg0, arg1);
    }

    @Override
    public Object compute(Object arg0, BiFunction<? super Object, ? super Object, ?> arg1) {
        return this.props.compute(arg0, arg1);
    }

    @Override
    public Object merge(Object arg0, Object arg1, BiFunction<? super Object, ? super Object, ?> arg2) {
        return this.props.merge(arg0, arg1, arg2);
    }
}

