/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;

public class JobState
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobState\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Job state that is updated at the end of an execution\",\"fields\":[{\"name\":\"lowWatermark\",\"type\":\"string\",\"doc\":\"Low watermark after last execution\"},{\"name\":\"highWatermark\",\"type\":\"string\",\"doc\":\"High watermark after last execution\"}]}");
    private static final RecordDataSchema.Field FIELD_LowWatermark = SCHEMA.getField("lowWatermark");
    private static final RecordDataSchema.Field FIELD_HighWatermark = SCHEMA.getField("highWatermark");

    public JobState() {
        super(new DataMap(), SCHEMA);
    }

    public JobState(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasLowWatermark() {
        return this.contains(FIELD_LowWatermark);
    }

    public void removeLowWatermark() {
        this.remove(FIELD_LowWatermark);
    }

    public String getLowWatermark(GetMode mode) {
        return (String)this.obtainDirect(FIELD_LowWatermark, String.class, mode);
    }

    @Nonnull
    public String getLowWatermark() {
        return (String)this.obtainDirect(FIELD_LowWatermark, String.class, GetMode.STRICT);
    }

    public JobState setLowWatermark(String value, SetMode mode) {
        this.putDirect(FIELD_LowWatermark, String.class, String.class, value, mode);
        return this;
    }

    public JobState setLowWatermark(@Nonnull String value) {
        this.putDirect(FIELD_LowWatermark, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighWatermark() {
        return this.contains(FIELD_HighWatermark);
    }

    public void removeHighWatermark() {
        this.remove(FIELD_HighWatermark);
    }

    public String getHighWatermark(GetMode mode) {
        return (String)this.obtainDirect(FIELD_HighWatermark, String.class, mode);
    }

    @Nonnull
    public String getHighWatermark() {
        return (String)this.obtainDirect(FIELD_HighWatermark, String.class, GetMode.STRICT);
    }

    public JobState setHighWatermark(String value, SetMode mode) {
        this.putDirect(FIELD_HighWatermark, String.class, String.class, value, mode);
        return this;
    }

    public JobState setHighWatermark(@Nonnull String value) {
        this.putDirect(FIELD_HighWatermark, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobState clone() throws CloneNotSupportedException {
        return (JobState)super.clone();
    }

    public JobState copy() throws CloneNotSupportedException {
        return (JobState)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec lowWatermark() {
            return new PathSpec(this.getPathComponents(), "lowWatermark");
        }

        public PathSpec highWatermark() {
            return new PathSpec(this.getPathComponents(), "highWatermark");
        }
    }
}

