/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.gobblin.service.ExecutionStatus;
import org.apache.gobblin.service.FlowStatistics;
import org.apache.gobblin.service.FlowStatusId;
import org.apache.gobblin.service.JobStatusArray;

public class FlowStatus
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"FlowStatus\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Status of a flow\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"record\",\"name\":\"FlowStatusId\",\"doc\":\"Identifier for a specific execution of a flow\",\"fields\":[{\"name\":\"flowName\",\"type\":\"string\",\"doc\":\"Name of the flow\"},{\"name\":\"flowGroup\",\"type\":\"string\",\"doc\":\"Group of the flow. This defines the namespace for the flow.\"},{\"name\":\"flowExecutionId\",\"type\":\"long\",\"doc\":\"Execution id for the flow\"}]},\"doc\":\"Flow status identifier\"},{\"name\":\"executionStatistics\",\"type\":{\"type\":\"record\",\"name\":\"FlowStatistics\",\"doc\":\"Statistics from a flow execution\",\"fields\":[{\"name\":\"executionStartTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution began\"},{\"name\":\"executionEndTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution ended\"}]},\"doc\":\"Statistics for this execution of the flow\"},{\"name\":\"executionStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExecutionStatus\",\"doc\":\"Execution status for a flow or job\",\"symbols\":[\"RUNNING\",\"FAILED\",\"COMPLETE\"],\"symbolDocs\":{\"RUNNING\":\"Flow or job is currently executing\",\"FAILED\":\"Flow or job failed\",\"COMPLETE\":\"Flow or job completed execution\"}},\"doc\":\"Flow execution status\"},{\"name\":\"message\",\"type\":\"string\",\"doc\":\"Error or status message\"},{\"name\":\"jobStatuses\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"JobStatus\",\"doc\":\"Execution status for a job\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"record\",\"name\":\"FlowId\",\"doc\":\"Identifier for a Gobblin as a Service flow\",\"fields\":[{\"name\":\"flowName\",\"type\":\"string\",\"doc\":\"Name of the flow\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"flowGroup\",\"type\":\"string\",\"doc\":\"Group of the flow. This defines the namespace for the flow.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the flow the job belongs to\"},{\"name\":\"jobId\",\"type\":{\"type\":\"record\",\"name\":\"JobId\",\"doc\":\"Identifier for a Gobblin job\",\"fields\":[{\"name\":\"jobName\",\"type\":\"string\",\"doc\":\"Name of the job\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"jobGroup\",\"type\":\"string\",\"doc\":\"Group of the job. This defines the namespace for the job.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the job\"},{\"name\":\"executionStatus\",\"type\":\"ExecutionStatus\",\"doc\":\"Job execution status\"},{\"name\":\"message\",\"type\":\"string\",\"doc\":\"Error or status message\"},{\"name\":\"executionStatistics\",\"type\":{\"type\":\"record\",\"name\":\"JobStatistics\",\"doc\":\"Statistics from a job execution\",\"fields\":[{\"name\":\"executionStartTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution began\"},{\"name\":\"executionEndTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution ended\"},{\"name\":\"processedCount\",\"type\":\"long\",\"doc\":\"number of records processed in the last job execution\"}]},\"doc\":\"Statistics from the job execution. The values may be updated during the run of a job.\"},{\"name\":\"jobState\",\"type\":{\"type\":\"record\",\"name\":\"JobState\",\"doc\":\"Job state that is updated at the end of an execution\",\"fields\":[{\"name\":\"lowWatermark\",\"type\":\"string\",\"doc\":\"Low watermark after last execution\"},{\"name\":\"highWatermark\",\"type\":\"string\",\"doc\":\"High watermark after last execution\"}]},\"doc\":\"Job state that is updated only at the start and end of a job execution.\"}]}},\"doc\":\"Status of jobs belonging to the flow\"}]}");
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_ExecutionStatistics = SCHEMA.getField("executionStatistics");
    private static final RecordDataSchema.Field FIELD_ExecutionStatus = SCHEMA.getField("executionStatus");
    private static final RecordDataSchema.Field FIELD_Message = SCHEMA.getField("message");
    private static final RecordDataSchema.Field FIELD_JobStatuses = SCHEMA.getField("jobStatuses");

    public FlowStatus() {
        super(new DataMap(), SCHEMA);
    }

    public FlowStatus(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasId() {
        return this.contains(FIELD_Id);
    }

    public void removeId() {
        this.remove(FIELD_Id);
    }

    public FlowStatusId getId(GetMode mode) {
        return (FlowStatusId)this.obtainWrapped(FIELD_Id, FlowStatusId.class, mode);
    }

    @Nonnull
    public FlowStatusId getId() {
        return (FlowStatusId)this.obtainWrapped(FIELD_Id, FlowStatusId.class, GetMode.STRICT);
    }

    public FlowStatus setId(FlowStatusId value, SetMode mode) {
        this.putWrapped(FIELD_Id, FlowStatusId.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowStatus setId(@Nonnull FlowStatusId value) {
        this.putWrapped(FIELD_Id, FlowStatusId.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasExecutionStatistics() {
        return this.contains(FIELD_ExecutionStatistics);
    }

    public void removeExecutionStatistics() {
        this.remove(FIELD_ExecutionStatistics);
    }

    public FlowStatistics getExecutionStatistics(GetMode mode) {
        return (FlowStatistics)this.obtainWrapped(FIELD_ExecutionStatistics, FlowStatistics.class, mode);
    }

    @Nonnull
    public FlowStatistics getExecutionStatistics() {
        return (FlowStatistics)this.obtainWrapped(FIELD_ExecutionStatistics, FlowStatistics.class, GetMode.STRICT);
    }

    public FlowStatus setExecutionStatistics(FlowStatistics value, SetMode mode) {
        this.putWrapped(FIELD_ExecutionStatistics, FlowStatistics.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowStatus setExecutionStatistics(@Nonnull FlowStatistics value) {
        this.putWrapped(FIELD_ExecutionStatistics, FlowStatistics.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasExecutionStatus() {
        return this.contains(FIELD_ExecutionStatus);
    }

    public void removeExecutionStatus() {
        this.remove(FIELD_ExecutionStatus);
    }

    public ExecutionStatus getExecutionStatus(GetMode mode) {
        return (ExecutionStatus)((Object)this.obtainDirect(FIELD_ExecutionStatus, ExecutionStatus.class, mode));
    }

    @Nonnull
    public ExecutionStatus getExecutionStatus() {
        return (ExecutionStatus)((Object)this.obtainDirect(FIELD_ExecutionStatus, ExecutionStatus.class, GetMode.STRICT));
    }

    public FlowStatus setExecutionStatus(ExecutionStatus value, SetMode mode) {
        this.putDirect(FIELD_ExecutionStatus, ExecutionStatus.class, String.class, (Object)value, mode);
        return this;
    }

    public FlowStatus setExecutionStatus(@Nonnull ExecutionStatus value) {
        this.putDirect(FIELD_ExecutionStatus, ExecutionStatus.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMessage() {
        return this.contains(FIELD_Message);
    }

    public void removeMessage() {
        this.remove(FIELD_Message);
    }

    public String getMessage(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Message, String.class, mode);
    }

    @Nonnull
    public String getMessage() {
        return (String)this.obtainDirect(FIELD_Message, String.class, GetMode.STRICT);
    }

    public FlowStatus setMessage(String value, SetMode mode) {
        this.putDirect(FIELD_Message, String.class, String.class, value, mode);
        return this;
    }

    public FlowStatus setMessage(@Nonnull String value) {
        this.putDirect(FIELD_Message, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobStatuses() {
        return this.contains(FIELD_JobStatuses);
    }

    public void removeJobStatuses() {
        this.remove(FIELD_JobStatuses);
    }

    public JobStatusArray getJobStatuses(GetMode mode) {
        return (JobStatusArray)this.obtainWrapped(FIELD_JobStatuses, JobStatusArray.class, mode);
    }

    @Nonnull
    public JobStatusArray getJobStatuses() {
        return (JobStatusArray)this.obtainWrapped(FIELD_JobStatuses, JobStatusArray.class, GetMode.STRICT);
    }

    public FlowStatus setJobStatuses(JobStatusArray value, SetMode mode) {
        this.putWrapped(FIELD_JobStatuses, JobStatusArray.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowStatus setJobStatuses(@Nonnull JobStatusArray value) {
        this.putWrapped(FIELD_JobStatuses, JobStatusArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public FlowStatus clone() throws CloneNotSupportedException {
        return (FlowStatus)super.clone();
    }

    public FlowStatus copy() throws CloneNotSupportedException {
        return (FlowStatus)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FlowStatusId.Fields id() {
            return new FlowStatusId.Fields(this.getPathComponents(), "id");
        }

        public FlowStatistics.Fields executionStatistics() {
            return new FlowStatistics.Fields(this.getPathComponents(), "executionStatistics");
        }

        public PathSpec executionStatus() {
            return new PathSpec(this.getPathComponents(), "executionStatus");
        }

        public PathSpec message() {
            return new PathSpec(this.getPathComponents(), "message");
        }

        public JobStatusArray.Fields jobStatuses() {
            return new JobStatusArray.Fields(this.getPathComponents(), "jobStatuses");
        }
    }
}

