/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kafka.api.PartitionFetchInfo;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.FetchRequest;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaOffsetRetrievalFailureException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KafkaWrapper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWrapper.class);
    private static final String USE_NEW_KAFKA_API = "use.new.kafka.api";
    private static final boolean DEFAULT_USE_NEW_KAFKA_API = false;
    private final List<String> brokers;
    private final KafkaAPI kafkaAPI;
    private final boolean useNewKafkaAPI;

    private KafkaWrapper(Builder builder) {
        this.useNewKafkaAPI = builder.useNewKafkaAPI;
        this.brokers = builder.brokers;
        this.kafkaAPI = this.getKafkaAPI(builder.config);
    }

    public static KafkaWrapper create(State state) {
        Preconditions.checkNotNull((Object)state.getProp("kafka.brokers"), (Object)"Need to specify at least one Kafka broker.");
        Builder builder = new Builder();
        if (state.getPropAsBoolean(USE_NEW_KAFKA_API, false)) {
            builder = builder.withNewKafkaAPI();
        }
        Config config = ConfigUtils.propertiesToConfig((Properties)state.getProperties());
        return builder.withBrokers(state.getPropAsList("kafka.brokers")).withConfig(config).build();
    }

    public List<String> getBrokers() {
        return this.brokers;
    }

    public List<KafkaTopic> getFilteredTopics(List<Pattern> blacklist, List<Pattern> whitelist) {
        return this.kafkaAPI.getFilteredTopics(blacklist, whitelist);
    }

    public long getEarliestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
        return this.kafkaAPI.getEarliestOffset(partition);
    }

    public long getLatestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
        return this.kafkaAPI.getLatestOffset(partition);
    }

    public Iterator<MessageAndOffset> fetchNextMessageBuffer(KafkaPartition partition, long nextOffset, long maxOffset) {
        return this.kafkaAPI.fetchNextMessageBuffer(partition, nextOffset, maxOffset);
    }

    private KafkaAPI getKafkaAPI(Config config) {
        if (this.useNewKafkaAPI) {
            return new KafkaNewAPI(config);
        }
        return new KafkaOldAPI(config);
    }

    @Override
    public void close() throws IOException {
        this.kafkaAPI.close();
    }

    @Deprecated
    private class KafkaNewAPI
    extends KafkaAPI {
        protected KafkaNewAPI(Config config) {
            super(config);
        }

        @Override
        public List<KafkaTopic> getFilteredTopics(List<Pattern> blacklist, List<Pattern> whitelist) {
            throw new NotImplementedException("kafka new API has not been implemented");
        }

        @Override
        protected long getEarliestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
            throw new NotImplementedException("kafka new API has not been implemented");
        }

        @Override
        protected long getLatestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
            throw new NotImplementedException("kafka new API has not been implemented");
        }

        @Override
        public void close() throws IOException {
            throw new NotImplementedException("kafka new API has not been implemented");
        }

        @Override
        protected Iterator<MessageAndOffset> fetchNextMessageBuffer(KafkaPartition partition, long nextOffset, long maxOffset) {
            throw new NotImplementedException("kafka new API has not been implemented");
        }
    }

    @Deprecated
    private class KafkaOldAPI
    extends KafkaAPI {
        public static final String CONFIG_PREFIX = "source.kafka.";
        public static final String CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE = "source.kafka.socketTimeoutMillis";
        public static final int CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE_DEFAULT = 30000;
        public static final String CONFIG_KAFKA_BUFFER_SIZE_BYTES = "source.kafka.bufferSizeBytes";
        public static final int CONFIG_KAFKA_BUFFER_SIZE_BYTES_DEFAULT = 0x100000;
        public static final String CONFIG_KAFKA_CLIENT_NAME = "source.kafka.clientName";
        public static final String CONFIG_KAFKA_CLIENT_NAME_DEFAULT = "gobblin-kafka";
        public static final String CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID = "source.kafka.fetchCorrelationId";
        private static final int CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID_DEFAULT = -1;
        public static final String CONFIG_KAFKA_FETCH_TIMEOUT_VALUE = "source.kafka.fetchTimeoutMillis";
        public static final int CONFIG_KAFKA_FETCH_TIMEOUT_VALUE_DEFAULT = 1000;
        public static final String CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES = "source.kafka.fetchMinBytes";
        private static final int CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES_DEFAULT = 1024;
        public static final String CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES = "source.kafka.fetchTopicNumTries";
        private static final int CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES_DEFAULT = 3;
        public static final String CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES = "source.kafka.fetchOffsetNumTries";
        private static final int CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES_DEFAULT = 3;
        private final int socketTimeoutMillis;
        private final int bufferSize;
        private final String clientName;
        private final int fetchCorrelationId;
        private final int fetchTimeoutMillis;
        private final int fetchMinBytes;
        private final int fetchTopicRetries;
        private final int fetchOffsetRetries;
        private final ConcurrentMap<String, SimpleConsumer> activeConsumers;

        protected KafkaOldAPI(Config config) {
            super(config);
            this.activeConsumers = Maps.newConcurrentMap();
            this.socketTimeoutMillis = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE, (Integer)30000);
            this.bufferSize = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_BUFFER_SIZE_BYTES, (Integer)0x100000);
            this.clientName = ConfigUtils.getString((Config)config, (String)CONFIG_KAFKA_CLIENT_NAME, (String)CONFIG_KAFKA_CLIENT_NAME_DEFAULT);
            this.fetchCorrelationId = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID, (Integer)-1);
            this.fetchTimeoutMillis = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_TIMEOUT_VALUE, (Integer)1000);
            this.fetchMinBytes = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES, (Integer)1024);
            this.fetchTopicRetries = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES, (Integer)3);
            this.fetchOffsetRetries = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES, (Integer)3);
            Preconditions.checkArgument((this.fetchTimeoutMillis < this.socketTimeoutMillis ? 1 : 0) != 0, (Object)("Kafka Source configuration error: FetchTimeout " + this.fetchTimeoutMillis + " must be smaller than SocketTimeout " + this.socketTimeoutMillis));
        }

        @Override
        public List<KafkaTopic> getFilteredTopics(List<Pattern> blacklist, List<Pattern> whitelist) {
            List<TopicMetadata> topicMetadataList = this.getFilteredMetadataList(blacklist, whitelist);
            ArrayList filteredTopics = Lists.newArrayList();
            for (TopicMetadata topicMetadata : topicMetadataList) {
                List<KafkaPartition> partitions = this.getPartitionsForTopic(topicMetadata);
                filteredTopics.add(new KafkaTopic(topicMetadata.topic(), partitions));
            }
            return filteredTopics;
        }

        private List<KafkaPartition> getPartitionsForTopic(TopicMetadata topicMetadata) {
            ArrayList partitions = Lists.newArrayList();
            for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
                if (null == partitionMetadata) {
                    LOG.error("Ignoring topic with null partition metadata " + topicMetadata.topic());
                    return Collections.emptyList();
                }
                if (null == partitionMetadata.leader()) {
                    LOG.error("Ignoring topic with null partition leader " + topicMetadata.topic() + " metatada=" + partitionMetadata);
                    return Collections.emptyList();
                }
                partitions.add(new KafkaPartition.Builder().withId(partitionMetadata.partitionId()).withTopicName(topicMetadata.topic()).withLeaderId(partitionMetadata.leader().id()).withLeaderHostAndPort(partitionMetadata.leader().host(), partitionMetadata.leader().port()).build());
            }
            return partitions;
        }

        private List<TopicMetadata> getFilteredMetadataList(List<Pattern> blacklist, List<Pattern> whitelist) {
            List<Object> filteredTopicMetadataList = Lists.newArrayList();
            for (String broker : KafkaWrapper.this.getBrokers()) {
                filteredTopicMetadataList = this.fetchTopicMetadataFromBroker(broker, blacklist, whitelist);
                if (filteredTopicMetadataList == null) continue;
                return filteredTopicMetadataList;
            }
            throw new RuntimeException("Fetching topic metadata from all brokers failed. See log warning for more information.");
        }

        private List<TopicMetadata> fetchTopicMetadataFromBroker(String broker, List<Pattern> blacklist, List<Pattern> whitelist) {
            List<TopicMetadata> topicMetadataList = this.fetchTopicMetadataFromBroker(broker, new String[0]);
            if (topicMetadataList == null) {
                return null;
            }
            ArrayList filteredTopicMetadataList = Lists.newArrayList();
            for (TopicMetadata topicMetadata : topicMetadataList) {
                if (!DatasetFilterUtils.survived((String)topicMetadata.topic(), blacklist, whitelist)) continue;
                filteredTopicMetadataList.add(topicMetadata);
            }
            return filteredTopicMetadataList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private List<TopicMetadata> fetchTopicMetadataFromBroker(String broker, String ... selectedTopics) {
            LOG.info(String.format("Fetching topic metadata from broker %s", broker));
            try (SimpleConsumer consumer = null;){
                consumer = this.getSimpleConsumer(broker);
                for (int i = 0; i < this.fetchTopicRetries; ++i) {
                    try {
                        List list = consumer.send(new TopicMetadataRequest(Arrays.asList(selectedTopics))).topicsMetadata();
                        return list;
                    }
                    catch (Exception e) {
                        try {
                            LOG.warn(String.format("Fetching topic metadata from broker %s has failed %d times.", broker, i + 1), (Throwable)e);
                            try {
                                Thread.sleep((long)(((double)i + Math.random()) * 1000.0));
                            }
                            catch (InterruptedException e2) {
                                LOG.warn("Caught InterruptedException: " + e2);
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
        }

        private SimpleConsumer getSimpleConsumer(String broker) {
            if (this.activeConsumers.containsKey(broker)) {
                return (SimpleConsumer)this.activeConsumers.get(broker);
            }
            SimpleConsumer consumer = this.createSimpleConsumer(broker);
            this.activeConsumers.putIfAbsent(broker, consumer);
            return consumer;
        }

        private SimpleConsumer getSimpleConsumer(HostAndPort hostAndPort) {
            return this.getSimpleConsumer(hostAndPort.toString());
        }

        private SimpleConsumer createSimpleConsumer(String broker) {
            List hostPort = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)broker);
            return this.createSimpleConsumer((String)hostPort.get(0), Integer.parseInt((String)hostPort.get(1)));
        }

        private SimpleConsumer createSimpleConsumer(String host, int port) {
            return new SimpleConsumer(host, port, this.socketTimeoutMillis, this.bufferSize, this.clientName);
        }

        @Override
        protected long getEarliestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
            Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo = Collections.singletonMap(new TopicAndPartition(partition.getTopicName(), partition.getId()), new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.EarliestTime(), 1));
            return this.getOffset(partition, offsetRequestInfo);
        }

        @Override
        protected long getLatestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
            Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo = Collections.singletonMap(new TopicAndPartition(partition.getTopicName(), partition.getId()), new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), 1));
            return this.getOffset(partition, offsetRequestInfo);
        }

        private long getOffset(KafkaPartition partition, Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo) throws KafkaOffsetRetrievalFailureException {
            SimpleConsumer consumer = this.getSimpleConsumer(partition.getLeader().getHostAndPort());
            for (int i = 0; i < this.fetchOffsetRetries; ++i) {
                try {
                    OffsetResponse offsetResponse = consumer.getOffsetsBefore(new OffsetRequest(offsetRequestInfo, kafka.api.OffsetRequest.CurrentVersion(), this.clientName));
                    if (offsetResponse.hasError()) {
                        throw new RuntimeException("offsetReponse has error: " + offsetResponse.errorCode(partition.getTopicName(), partition.getId()));
                    }
                    return offsetResponse.offsets(partition.getTopicName(), partition.getId())[0];
                }
                catch (Exception e) {
                    LOG.warn(String.format("Fetching offset for partition %s has failed %d time(s). Reason: %s", partition, i + 1, e));
                    if (i >= this.fetchOffsetRetries - 1) continue;
                    try {
                        Thread.sleep((long)(((double)i + Math.random()) * 1000.0));
                    }
                    catch (InterruptedException e2) {
                        LOG.error("Caught interrupted exception between retries of getting latest offsets. " + e2);
                    }
                    continue;
                }
            }
            throw new KafkaOffsetRetrievalFailureException(String.format("Fetching offset for partition %s has failed.", partition));
        }

        @Override
        protected Iterator<MessageAndOffset> fetchNextMessageBuffer(KafkaPartition partition, long nextOffset, long maxOffset) {
            if (nextOffset > maxOffset) {
                return null;
            }
            FetchRequest fetchRequest = this.createFetchRequest(partition, nextOffset);
            try {
                FetchResponse fetchResponse = this.getFetchResponseForFetchRequest(fetchRequest, partition);
                return this.getIteratorFromFetchResponse(fetchResponse, partition);
            }
            catch (Exception e) {
                LOG.warn(String.format("Fetch message buffer for partition %s has failed: %s. Will refresh topic metadata and retry", partition, e));
                return this.refreshTopicMetadataAndRetryFetch(partition, fetchRequest);
            }
        }

        private synchronized FetchResponse getFetchResponseForFetchRequest(FetchRequest fetchRequest, KafkaPartition partition) {
            SimpleConsumer consumer = this.getSimpleConsumer(partition.getLeader().getHostAndPort());
            FetchResponse fetchResponse = consumer.fetch(fetchRequest);
            if (fetchResponse.hasError()) {
                throw new RuntimeException(String.format("error code %d", fetchResponse.errorCode(partition.getTopicName(), partition.getId())));
            }
            return fetchResponse;
        }

        private Iterator<MessageAndOffset> getIteratorFromFetchResponse(FetchResponse fetchResponse, KafkaPartition partition) {
            try {
                ByteBufferMessageSet messageBuffer = fetchResponse.messageSet(partition.getTopicName(), partition.getId());
                return messageBuffer.iterator();
            }
            catch (Exception e) {
                LOG.warn(String.format("Failed to retrieve next message buffer for partition %s: %s.The remainder of this partition will be skipped.", partition, e));
                return null;
            }
        }

        private Iterator<MessageAndOffset> refreshTopicMetadataAndRetryFetch(KafkaPartition partition, FetchRequest fetchRequest) {
            try {
                this.refreshTopicMetadata(partition);
                FetchResponse fetchResponse = this.getFetchResponseForFetchRequest(fetchRequest, partition);
                return this.getIteratorFromFetchResponse(fetchResponse, partition);
            }
            catch (Exception e) {
                LOG.warn(String.format("Fetch message buffer for partition %s has failed: %s. This partition will be skipped.", partition, e));
                return null;
            }
        }

        private void refreshTopicMetadata(KafkaPartition partition) {
            block0: for (String broker : KafkaWrapper.this.getBrokers()) {
                List<TopicMetadata> topicMetadataList = this.fetchTopicMetadataFromBroker(broker, partition.getTopicName());
                if (topicMetadataList == null || topicMetadataList.isEmpty()) continue;
                TopicMetadata topicMetadata = topicMetadataList.get(0);
                for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
                    if (partitionMetadata.partitionId() != partition.getId()) continue;
                    partition.setLeader(partitionMetadata.leader().id(), partitionMetadata.leader().host(), partitionMetadata.leader().port());
                    break block0;
                }
            }
        }

        private FetchRequest createFetchRequest(KafkaPartition partition, long nextOffset) {
            TopicAndPartition topicAndPartition = new TopicAndPartition(partition.getTopicName(), partition.getId());
            PartitionFetchInfo partitionFetchInfo = new PartitionFetchInfo(nextOffset, this.bufferSize);
            Map<TopicAndPartition, PartitionFetchInfo> fetchInfo = Collections.singletonMap(topicAndPartition, partitionFetchInfo);
            return new FetchRequest(this.fetchCorrelationId, this.clientName, this.fetchTimeoutMillis, this.fetchMinBytes, fetchInfo);
        }

        @Override
        public void close() throws IOException {
            int numOfConsumersNotClosed = 0;
            for (SimpleConsumer consumer : this.activeConsumers.values()) {
                if (consumer == null) continue;
                try {
                    consumer.close();
                }
                catch (Exception e) {
                    LOG.warn(String.format("Failed to close Kafka Consumer %s:%d", consumer.host(), consumer.port()));
                    ++numOfConsumersNotClosed;
                }
            }
            this.activeConsumers.clear();
            if (numOfConsumersNotClosed > 0) {
                throw new IOException(numOfConsumersNotClosed + " consumer(s) failed to close.");
            }
        }
    }

    @Deprecated
    private abstract class KafkaAPI
    implements Closeable {
        protected KafkaAPI(Config config) {
        }

        protected abstract List<KafkaTopic> getFilteredTopics(List<Pattern> var1, List<Pattern> var2);

        protected abstract long getEarliestOffset(KafkaPartition var1) throws KafkaOffsetRetrievalFailureException;

        protected abstract long getLatestOffset(KafkaPartition var1) throws KafkaOffsetRetrievalFailureException;

        protected abstract Iterator<MessageAndOffset> fetchNextMessageBuffer(KafkaPartition var1, long var2, long var4);
    }

    private static class Builder {
        private boolean useNewKafkaAPI = false;
        private List<String> brokers = Lists.newArrayList();
        private Config config = ConfigFactory.empty();

        private Builder() {
        }

        private Builder withNewKafkaAPI() {
            this.useNewKafkaAPI = true;
            return this;
        }

        private Builder withBrokers(List<String> brokers) {
            for (String broker : brokers) {
                Preconditions.checkArgument((boolean)broker.matches(".+:\\d+"), (Object)String.format("Invalid broker: %s. Must be in the format of address:port.", broker));
            }
            this.brokers = Lists.newArrayList(brokers);
            return this;
        }

        private Builder withConfig(Config config) {
            this.config = config;
            return this;
        }

        private KafkaWrapper build() {
            Preconditions.checkArgument((!this.brokers.isEmpty() ? 1 : 0) != 0, (Object)"Need to specify at least one Kafka broker.");
            return new KafkaWrapper(this);
        }
    }
}

