/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.writer;

import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.kafka.writer.KafkaWriterHelper;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.apache.gobblin.writer.WriteResponseFuture;
import org.apache.gobblin.writer.WriteResponseMapper;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kafka08DataWriter<D>
implements AsyncDataWriter<D> {
    private static final Logger log = LoggerFactory.getLogger(Kafka08DataWriter.class);
    private static final WriteResponseMapper<RecordMetadata> WRITE_RESPONSE_WRAPPER = new WriteResponseMapper<RecordMetadata>(){

        public WriteResponse wrap(final RecordMetadata recordMetadata) {
            return new WriteResponse<RecordMetadata>(){

                public RecordMetadata getRawResponse() {
                    return recordMetadata;
                }

                public String getStringResponse() {
                    return recordMetadata.toString();
                }

                public long bytesWritten() {
                    return -1L;
                }
            };
        }
    };
    private final Producer<String, D> producer;
    private final String topic;

    public static Producer getKafkaProducer(Properties props) {
        Object producerObject = KafkaWriterHelper.getKafkaProducer((Properties)props);
        try {
            Producer producer = (Producer)producerObject;
            return producer;
        }
        catch (ClassCastException e) {
            log.error("Failed to instantiate Kafka producer " + producerObject.getClass().getName() + " as instance of Producer.class", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Kafka08DataWriter(Properties props) {
        this(Kafka08DataWriter.getKafkaProducer(props), ConfigFactory.parseProperties((Properties)props));
    }

    public Kafka08DataWriter(Producer producer, Config config) {
        this.topic = config.getString("writer.kafka.topic");
        this.producer = producer;
    }

    public void close() throws IOException {
        log.debug("Close called");
        this.producer.close();
    }

    public Future<WriteResponse> write(D record, final WriteCallback callback) {
        return new WriteResponseFuture(this.producer.send(new ProducerRecord(this.topic, record), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    callback.onFailure((Throwable)exception);
                } else {
                    callback.onSuccess((Object)WRITE_RESPONSE_WRAPPER.wrap((Object)metadata));
                }
            }
        }), WRITE_RESPONSE_WRAPPER);
    }

    public void flush() throws IOException {
    }
}

